/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.analyze.ConstraintsValidator;
import io.crate.analyze.expressions.ValueNormalizer;
import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.expression.eval.EvaluatingNormalizer;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.CoordinatorTxnCtx;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Reference;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.planner.operators.SubQueryAndParamBinder;
import io.crate.planner.operators.SubQueryResults;
import java.util.Map;
import javax.annotation.Nonnull;

public final class Assignments {
    private final String[] targetNames;
    private final Reference[] targetColumns;
    private final Symbol[] sources;
    private final EvaluatingNormalizer normalizer;

    public static Assignments convert(@Nonnull Map<Reference, ? extends Symbol> assignments, NodeContext nodeCtx) {
        String[] targetNames = new String[assignments.size()];
        Reference[] targetColumns = new Reference[assignments.size()];
        Symbol[] assignmentSymbols = new Symbol[assignments.size()];
        int i = 0;
        for (Map.Entry<Reference, ? extends Symbol> entry : assignments.entrySet()) {
            Reference key = entry.getKey();
            targetNames[i] = key.column().fqn();
            assignmentSymbols[i] = entry.getValue();
            targetColumns[i] = key;
            ++i;
        }
        return new Assignments(targetNames, targetColumns, assignmentSymbols, nodeCtx);
    }

    private Assignments(String[] targetNames, Reference[] targetColumns, Symbol[] sources, NodeContext nodeCtx) {
        this.targetNames = targetNames;
        this.targetColumns = targetColumns;
        this.sources = sources;
        this.normalizer = EvaluatingNormalizer.functionOnlyNormalizer(nodeCtx);
    }

    public String[] targetNames() {
        return this.targetNames;
    }

    public Symbol[] sources() {
        return this.sources;
    }

    public Symbol[] bindSources(DocTableInfo tableInfo, Row params, SubQueryResults subQueryResults) {
        Symbol[] boundSources = new Symbol[this.targetColumns.length];
        SubQueryAndParamBinder binder = new SubQueryAndParamBinder(params, subQueryResults);
        for (int i = 0; i < boundSources.length; ++i) {
            Symbol source = ValueNormalizer.normalizeInputForReference(binder.apply(this.sources[i]), this.targetColumns[i], tableInfo, s -> this.normalizer.normalize((Symbol)s, CoordinatorTxnCtx.systemTransactionContext()));
            if (source instanceof Input) {
                ConstraintsValidator.validate(((Input)((Object)source)).value(), this.targetColumns[i], tableInfo.notNullColumns());
            }
            boundSources[i] = source;
        }
        return boundSources;
    }
}

