/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.symbol.format.Style;
import io.crate.types.DataType;
import java.io.IOException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class AliasSymbol
extends Symbol {
    private final String alias;
    private final Symbol symbol;

    public AliasSymbol(String alias, Symbol symbol) {
        this.alias = alias;
        this.symbol = symbol;
    }

    public AliasSymbol(StreamInput in) throws IOException {
        this.alias = in.readString();
        this.symbol = Symbols.fromStream(in);
    }

    public Symbol symbol() {
        return this.symbol;
    }

    public String alias() {
        return this.alias;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.alias);
        Symbols.toStream(this.symbol, out);
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.ALIAS;
    }

    @Override
    public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
        return visitor.visitAlias(this, context);
    }

    @Override
    public DataType<?> valueType() {
        return this.symbol.valueType();
    }

    @Override
    public String toString(Style style) {
        return this.symbol.toString(style) + " AS " + this.alias;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliasSymbol that = (AliasSymbol)o;
        if (!this.alias.equals(that.alias)) {
            return false;
        }
        return this.symbol.equals(that.symbol);
    }

    public int hashCode() {
        int result = this.alias.hashCode();
        result = 31 * result + this.symbol.hashCode();
        return result;
    }
}

