/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.expression.symbol.SymbolType;
import io.crate.expression.symbol.SymbolVisitor;
import io.crate.expression.symbol.Symbols;
import io.crate.expression.symbol.format.Style;
import io.crate.metadata.FunctionIdent;
import io.crate.metadata.FunctionInfo;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class Aggregation
extends Symbol {
    private final FunctionInfo functionInfo;
    private final Signature signature;
    private final DataType<?> boundSignatureReturnType;
    private final List<Symbol> inputs;
    private final DataType<?> valueType;
    private final Symbol filter;

    public Aggregation(Signature signature, DataType<?> valueType, List<Symbol> inputs) {
        this(signature, FunctionInfo.of(signature, Symbols.typeView(inputs), valueType), valueType, valueType, inputs, Literal.BOOLEAN_TRUE);
    }

    public Aggregation(Signature signature, FunctionInfo functionInfo, DataType<?> boundSignatureReturnType, DataType<?> valueType, List<Symbol> inputs, Symbol filter) {
        Objects.requireNonNull(inputs, "inputs must not be null");
        Objects.requireNonNull(filter, "filter must not be null");
        this.valueType = valueType;
        this.functionInfo = functionInfo;
        this.signature = signature;
        this.boundSignatureReturnType = boundSignatureReturnType;
        this.inputs = inputs;
        this.filter = filter;
    }

    public Aggregation(StreamInput in) throws IOException {
        this.functionInfo = new FunctionInfo(in);
        this.valueType = DataTypes.fromStream(in);
        this.filter = in.getVersion().onOrAfter(Version.V_4_1_0) ? Symbols.fromStream(in) : Literal.BOOLEAN_TRUE;
        this.inputs = Symbols.listFromStream(in);
        if (in.getVersion().onOrAfter(Version.V_4_2_0) && in.readBoolean()) {
            this.signature = new Signature(in);
            this.boundSignatureReturnType = DataTypes.fromStream(in);
        } else {
            this.signature = null;
            this.boundSignatureReturnType = this.valueType;
        }
    }

    @Override
    public SymbolType symbolType() {
        return SymbolType.AGGREGATION;
    }

    @Override
    public <C, R> R accept(SymbolVisitor<C, R> visitor, C context) {
        return visitor.visitAggregation(this, context);
    }

    @Override
    public DataType<?> valueType() {
        return this.valueType;
    }

    public DataType<?> boundSignatureReturnType() {
        return this.boundSignatureReturnType;
    }

    public FunctionIdent functionIdent() {
        return this.functionInfo.ident();
    }

    @Nullable
    public Signature signature() {
        return this.signature;
    }

    public List<Symbol> inputs() {
        return this.inputs;
    }

    public Symbol filter() {
        return this.filter;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        this.functionInfo.writeTo(out);
        DataTypes.toStream(this.valueType, out);
        if (out.getVersion().onOrAfter(Version.V_4_1_0)) {
            Symbols.toStream(this.filter, out);
        }
        Symbols.toStream(this.inputs, out);
        if (out.getVersion().onOrAfter(Version.V_4_2_0)) {
            out.writeBoolean(this.signature != null);
            if (this.signature != null) {
                this.signature.writeTo(out);
                DataTypes.toStream(this.boundSignatureReturnType, out);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Aggregation that = (Aggregation)o;
        return Objects.equals(this.functionInfo, that.functionInfo) && Objects.equals(this.inputs, that.inputs) && Objects.equals(this.valueType, that.valueType) && Objects.equals(this.filter, that.filter);
    }

    public int hashCode() {
        return Objects.hash(this.functionInfo, this.inputs, this.valueType, this.filter);
    }

    @Override
    public String toString(Style style) {
        StringBuilder sb = new StringBuilder(this.functionInfo.ident().name()).append("(");
        for (int i = 0; i < this.inputs.size(); ++i) {
            sb.append(this.inputs.get(i).toString(style));
            if (i + 1 >= this.inputs.size()) continue;
            sb.append(", ");
        }
        sb.append(")");
        return sb.toString();
    }
}

