/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.symbol;

import io.crate.breaker.RamAccounting;
import io.crate.execution.engine.aggregation.AggregationFunction;
import io.crate.types.DataType;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public enum AggregateMode {
    ITER_PARTIAL{

        @Override
        public DataType<?> returnType(AggregationFunction<?, ?> function) {
            return function.partialType();
        }

        @Override
        public <TP, TF> TF finishCollect(RamAccounting ramAccounting, AggregationFunction<TP, TF> function, TP state) {
            return (TF)state;
        }
    }
    ,
    ITER_FINAL,
    PARTIAL_FINAL;

    private static final List<AggregateMode> VALUES;

    public DataType<?> returnType(AggregationFunction<?, ?> function) {
        return function.boundSignature().getReturnType().createType();
    }

    public <TP, TF> TF finishCollect(RamAccounting ramAccounting, AggregationFunction<TP, TF> function, TP state) {
        return function.terminatePartial(ramAccounting, state);
    }

    public static void writeTo(AggregateMode mode, StreamOutput out) throws IOException {
        out.writeVInt(mode.ordinal());
    }

    public static AggregateMode readFrom(StreamInput in) throws IOException {
        return VALUES.get(in.readVInt());
    }

    static {
        VALUES = List.of(AggregateMode.values());
    }
}

