/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.timestamp;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Locale;

public class TimezoneFunction
extends Scalar<Long, Object> {
    public static final String NAME = "timezone";
    private static final ZoneId UTC = ZoneId.of("UTC");
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(NAME, DataTypes.STRING.getTypeSignature(), DataTypes.TIMESTAMPZ.getTypeSignature(), DataTypes.TIMESTAMP.getTypeSignature()), TimezoneFunction::new);
        module.register(Signature.scalar(NAME, DataTypes.STRING.getTypeSignature(), DataTypes.TIMESTAMP.getTypeSignature(), DataTypes.TIMESTAMPZ.getTypeSignature()), TimezoneFunction::new);
        module.register(Signature.scalar(NAME, DataTypes.STRING.getTypeSignature(), DataTypes.LONG.getTypeSignature(), DataTypes.TIMESTAMPZ.getTypeSignature()), TimezoneFunction::new);
    }

    private TimezoneFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Long evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        ZoneId zoneId;
        assert (args.length == 2) : String.format(Locale.ENGLISH, "number of arguments must be 2, got %d instead", args.length);
        String zoneStr = (String)args[0].value();
        if (zoneStr == null) {
            return null;
        }
        try {
            zoneId = ZoneId.of(zoneStr);
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, " time zone \"%s\" not recognized", zoneStr));
        }
        Number utcTimestamp = (Number)args[1].value();
        if (utcTimestamp == null) {
            return null;
        }
        Instant instant = Instant.ofEpochMilli(utcTimestamp.longValue());
        boolean paramHadTimezone = this.boundSignature.getReturnType().createType() == DataTypes.TIMESTAMP;
        ZoneId srcZoneId = paramHadTimezone ? zoneId : UTC;
        ZoneId dstZoneId = paramHadTimezone ? UTC : zoneId;
        ZonedDateTime zonedDateTime = instant.atZone(srcZoneId).withZoneSameLocal(dstZoneId);
        return zonedDateTime.toEpochSecond() * 1000L;
    }
}

