/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.timestamp;

import com.google.common.math.LongMath;
import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.math.RoundingMode;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Locale;

public class CurrentTimestampFunction
extends Scalar<Long, Integer> {
    public static final String NAME = "current_timestamp";
    public static final int DEFAULT_PRECISION = 3;
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(NAME, DataTypes.TIMESTAMPZ.getTypeSignature()).withFeatures(NO_FEATURES), CurrentTimestampFunction::new);
        module.register(Signature.scalar(NAME, DataTypes.INTEGER.getTypeSignature(), DataTypes.TIMESTAMPZ.getTypeSignature()).withFeatures(NO_FEATURES), CurrentTimestampFunction::new);
    }

    public CurrentTimestampFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    @SafeVarargs
    public final Long evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Integer> ... args) {
        Integer precision = 3;
        if (args.length == 1 && (precision = args[0].value()) == null) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "NULL precision not supported for %s", NAME));
        }
        return CurrentTimestampFunction.applyPrecision(ChronoUnit.MILLIS.between(Instant.EPOCH, txnCtx.currentInstant()), precision);
    }

    private static long applyPrecision(long millis, int precision) {
        int factor;
        switch (precision) {
            case 0: {
                factor = 1000;
                break;
            }
            case 1: {
                factor = 100;
                break;
            }
            case 2: {
                factor = 10;
                break;
            }
            case 3: {
                return millis;
            }
            default: {
                throw new IllegalArgumentException("Precision must be between 0 and 3");
            }
        }
        return LongMath.divide((long)millis, (long)factor, (RoundingMode)RoundingMode.DOWN) * (long)factor;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }
}

