/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.timestamp;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.TimeTZ;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Locale;

public class CurrentTimeFunction
extends Scalar<TimeTZ, Integer> {
    public static final String NAME = "current_time";
    private static final int MICRO_PRECISION = 6;
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(NAME, DataTypes.INTEGER.getTypeSignature(), DataTypes.TIMETZ.getTypeSignature()), CurrentTimeFunction::new);
        module.register(Signature.scalar(NAME, DataTypes.TIMETZ.getTypeSignature()), CurrentTimeFunction::new);
    }

    private CurrentTimeFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    @SafeVarargs
    public final TimeTZ evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Integer> ... args) {
        Integer precision = 6;
        if (args.length == 1) {
            precision = args[0].value();
            if (precision == null) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "NULL precision not supported for %s", this.signature.getName().name()));
            }
            if (precision < 0 || precision > 6) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "precision must be between [0..%d]", 6));
            }
        }
        Instant currentInstant = txnCtx.currentInstant();
        long microsSinceMidnight = ChronoUnit.MICROS.between(currentInstant.truncatedTo(ChronoUnit.DAYS), currentInstant);
        long factor = (long)Math.pow(10.0, 6 - precision);
        return new TimeTZ(microsSinceMidnight / factor * factor, 0);
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }
}

