/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.systeminformation;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.metadata.FunctionName;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.util.Locale;
import org.elasticsearch.Build;
import org.elasticsearch.Version;

public class VersionFunction
extends Scalar<String, Void> {
    public static final String NAME = "version";
    private static final FunctionName FQN = new FunctionName("pg_catalog", "version");
    private static final String VERSION = VersionFunction.formatVersion();
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(FQN, DataTypes.STRING.getTypeSignature()).withFeatures(Scalar.NO_FEATURES), VersionFunction::new);
    }

    private static String formatVersion() {
        String version = Version.displayVersion(Version.CURRENT, Version.CURRENT.isSnapshot());
        String built = String.format(Locale.ENGLISH, "built %s/%s", Build.CURRENT.hashShort(), Build.CURRENT.timestamp());
        String vmVersion = String.format(Locale.ENGLISH, "%s %s", System.getProperty("java.vm.name"), System.getProperty("java.vm.version"));
        String osVersion = String.format(Locale.ENGLISH, "%s %s %s", System.getProperty("os.name"), System.getProperty("os.version"), System.getProperty("os.arch"));
        return String.format(Locale.ENGLISH, "CrateDB %s (%s, %s, %s)", version, built, osVersion, vmVersion);
    }

    public VersionFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Void> ... args) {
        return VERSION;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }
}

