/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.systeminformation;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;

public final class PgFunctionIsVisibleFunction
extends Scalar<Boolean, Integer> {
    public static final String NAME = "pg_function_is_visible";
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(NAME, DataTypes.INTEGER.getTypeSignature(), DataTypes.BOOLEAN.getTypeSignature()), PgFunctionIsVisibleFunction::new);
    }

    public PgFunctionIsVisibleFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Integer> ... args) {
        assert (args.length == 1) : "pg_function_is_visible expects exactly 1 argument, got " + args.length;
        Integer oid = args[0].value();
        if (oid == null) {
            return null;
        }
        return nodeCtx.functions().findFunctionSignatureByOid(oid) != null;
    }
}

