/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.systeminformation;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.metadata.FunctionName;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.util.ArrayList;
import java.util.List;

public class CurrentSchemasFunction
extends Scalar<List<String>, Boolean> {
    public static final String NAME = "current_schemas";
    private static final FunctionName FQN = new FunctionName("pg_catalog", "current_schemas");
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(FQN, DataTypes.BOOLEAN.getTypeSignature(), DataTypes.STRING_ARRAY.getTypeSignature()).withFeatures(NO_FEATURES), CurrentSchemasFunction::new);
    }

    public CurrentSchemasFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    @SafeVarargs
    public final List<String> evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Boolean> ... args) {
        assert (args.length == 1) : "expecting 1 boolean argument";
        Boolean includeImplicitSchemas = args[0].value();
        if (includeImplicitSchemas == null) {
            includeImplicitSchemas = false;
        }
        ArrayList<String> schemas = new ArrayList<String>();
        for (String schema : txnCtx.sessionSettings().searchPath()) {
            if (!includeImplicitSchemas.booleanValue() && schema.equals("pg_catalog")) continue;
            schemas.add(schema);
        }
        return schemas;
    }
}

