/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.systeminformation;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.FunctionName;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import javax.annotation.Nullable;

public class CurrentSchemaFunction
extends Scalar<String, Object> {
    public static final String NAME = "current_schema";
    private static final FunctionName FQN = new FunctionName("pg_catalog", "current_schema");
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(FQN, DataTypes.STRING.getTypeSignature()).withFeatures(NO_FEATURES), CurrentSchemaFunction::new);
    }

    public CurrentSchemaFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        assert (args.length == 0) : "number of args must be 0";
        return txnCtx.sessionSettings().currentSchema();
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, @Nullable TransactionContext txnCtx, NodeContext nodeCtx) {
        if (txnCtx == null) {
            return Literal.NULL;
        }
        return Literal.of(txnCtx.sessionSettings().currentSchema());
    }
}

