/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.string;

import com.google.common.primitives.Chars;
import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.sql.tree.TrimMode;
import io.crate.types.DataTypes;
import java.util.HashSet;
import java.util.List;
import java.util.function.BiFunction;

public final class TrimFunctions {
    private static final String TRIM_NAME = "trim";
    private static final String LTRIM_NAME = "ltrim";
    private static final String RTRIM_NAME = "rtrim";

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(TRIM_NAME, DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()), (signature, boundSignature) -> new OneCharTrimFunction((Signature)signature, (Signature)boundSignature, ' '));
        module.register(Signature.scalar(TRIM_NAME, DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()), TrimFunction::new);
        module.register(Signature.scalar(LTRIM_NAME, DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()), (signature, boundSignature) -> new SingleSideTrimFunction((Signature)signature, (Signature)boundSignature, (i, c) -> TrimFunctions.trimChars(i, c, TrimMode.LEADING)));
        module.register(Signature.scalar(LTRIM_NAME, DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()), (signature, boundSignature) -> new SingleSideTrimFunction((Signature)signature, (Signature)boundSignature, (i, c) -> TrimFunctions.trimChars(i, c, TrimMode.LEADING)));
        module.register(Signature.scalar(RTRIM_NAME, DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()), (signature, boundSignature) -> new SingleSideTrimFunction((Signature)signature, (Signature)boundSignature, (i, c) -> TrimFunctions.trimChars(i, c, TrimMode.TRAILING)));
        module.register(Signature.scalar(RTRIM_NAME, DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()), (signature, boundSignature) -> new SingleSideTrimFunction((Signature)signature, (Signature)boundSignature, (i, c) -> TrimFunctions.trimChars(i, c, TrimMode.TRAILING)));
    }

    private static String trimChars(String target, String charsToTrimArg, TrimMode mode) {
        int len;
        HashSet<Character> charsToTrim = new HashSet<Character>(Chars.asList((char[])charsToTrimArg.toCharArray()));
        int start = mode.getStartIdx(target, charsToTrim);
        return start < (len = mode.getTrimmedLength(target, charsToTrim)) ? target.substring(start, len) : "";
    }

    private static class SingleSideTrimFunction
    extends Scalar<String, String> {
        private final Signature signature;
        private final Signature boundSignature;
        private final BiFunction<String, String, String> trimFunction;

        SingleSideTrimFunction(Signature signature, Signature boundSignature, BiFunction<String, String, String> function) {
            this.signature = signature;
            this.boundSignature = boundSignature;
            this.trimFunction = function;
        }

        @Override
        public Signature signature() {
            return this.signature;
        }

        @Override
        public Signature boundSignature() {
            return this.boundSignature;
        }

        @Override
        public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String>[] args) {
            String passedTrimmingText;
            assert (args.length == 1 || args.length == 2) : "number of args must be 1 or 2";
            String target = args[0].value();
            if (target == null) {
                return null;
            }
            if (args.length == 2 && (passedTrimmingText = args[1].value()) != null) {
                return this.trimFunction.apply(target, passedTrimmingText);
            }
            return this.trimFunction.apply(target, " ");
        }
    }

    private static class OneCharTrimFunction
    extends Scalar<String, String> {
        private final Signature signature;
        private final Signature boundSignature;
        private final char charToTrim;

        OneCharTrimFunction(Signature signature, Signature boundSignature, char charToTrim) {
            this.signature = signature;
            this.boundSignature = boundSignature;
            this.charToTrim = charToTrim;
        }

        @Override
        public Signature signature() {
            return this.signature;
        }

        @Override
        public Signature boundSignature() {
            return this.boundSignature;
        }

        @Override
        public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String>[] args) {
            int start;
            String target = args[0].value();
            if (target == null) {
                return null;
            }
            int len = target.length();
            for (start = 0; start < len && target.charAt(start) == this.charToTrim; ++start) {
            }
            while (start < len && target.charAt(len - 1) == this.charToTrim) {
                --len;
            }
            return target.substring(start, len);
        }
    }

    private static class TrimFunction
    extends Scalar<String, String> {
        private final Signature signature;
        private final Signature boundSignature;

        TrimFunction(Signature signature, Signature boundSignature) {
            this.signature = signature;
            this.boundSignature = boundSignature;
        }

        @Override
        public Signature signature() {
            return this.signature;
        }

        @Override
        public Signature boundSignature() {
            return this.boundSignature;
        }

        @Override
        public Scalar<String, String> compile(List<Symbol> arguments) {
            assert (arguments.size() == 3) : "number of args must be 3";
            Symbol modeSymbol = arguments.get(2);
            if (!Literal.isLiteral(modeSymbol, DataTypes.STRING)) {
                return this;
            }
            TrimMode mode = TrimMode.of((String)((Input)((Object)modeSymbol)).value());
            if (mode != TrimMode.BOTH) {
                return this;
            }
            Symbol charsToTrimSymbol = arguments.get(1);
            if (!Literal.isLiteral(charsToTrimSymbol, DataTypes.STRING)) {
                return this;
            }
            String charsToTrim = (String)((Input)((Object)charsToTrimSymbol)).value();
            if (charsToTrim.length() == 1) {
                return new OneCharTrimFunction(this.signature, this.boundSignature, charsToTrim.charAt(0));
            }
            return this;
        }

        @Override
        public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String>[] args) {
            assert (args.length == 3) : "number of args must be 3";
            String target = args[0].value();
            if (target == null) {
                return null;
            }
            String charsToTrimArg = args[1].value();
            if (charsToTrimArg == null) {
                return target;
            }
            TrimMode mode = TrimMode.of(args[2].value());
            return TrimFunctions.trimChars(target, charsToTrimArg, mode);
        }
    }
}

