/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.string;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TranslateFunction
extends Scalar<String, String> {
    private static final Character NULL = Character.valueOf('\u0000');
    private final Signature signature;
    private final Signature boundSignature;
    private final Map<Character, Character> tmap;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar("translate", DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()), TranslateFunction::new);
    }

    private TranslateFunction(Signature signature, Signature boundSignature) {
        this(signature, boundSignature, null);
    }

    public TranslateFunction(Signature signature, Signature boundSignature, Map<Character, Character> tmap) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.tmap = tmap;
    }

    @Override
    public Scalar<String, String> compile(List<Symbol> args) {
        assert (args.size() == 3) : "translate takes exactly three arguments";
        Symbol from = args.get(1);
        if (!Literal.isLiteral(from, DataTypes.STRING)) {
            return this;
        }
        Symbol to = args.get(2);
        if (!Literal.isLiteral(to, DataTypes.STRING)) {
            return this;
        }
        String fromStr = (String)((Input)((Object)from)).value();
        String toStr = (String)((Input)((Object)to)).value();
        return new TranslateFunction(this.signature, this.boundSignature, TranslateFunction.computeMap(fromStr, toStr));
    }

    @Override
    public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String>[] args) {
        assert (args.length == 3) : "translate takes exactly three arguments";
        String source = args[0].value();
        String from = args[1].value();
        String to = args[2].value();
        if (source == null || from == null || to == null) {
            return null;
        }
        if (source.length() == 0 || from.length() == 0) {
            return source;
        }
        return TranslateFunction.translate(this.tmap != null ? this.tmap : TranslateFunction.computeMap(from, to), source);
    }

    private static String translate(Map<Character, Character> tmap, String source) {
        int sourceLen = source.length();
        char[] result = new char[sourceLen];
        int resultCount = 0;
        for (int i = 0; i < sourceLen; ++i) {
            char c = source.charAt(i);
            Character mc = tmap.get(Character.valueOf(c));
            if (mc == null) {
                result[resultCount++] = c;
                continue;
            }
            if (mc == NULL) continue;
            result[resultCount++] = mc.charValue();
        }
        return String.valueOf(result, 0, resultCount);
    }

    private static Map<Character, Character> computeMap(String from, String to) {
        HashMap<Character, Character> tmap = new HashMap<Character, Character>();
        for (int i = 0; i < from.length(); ++i) {
            char c = from.charAt(i);
            tmap.putIfAbsent(Character.valueOf(c), Character.valueOf(i < to.length() ? to.charAt(i) : NULL.charValue()));
        }
        return tmap;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }
}

