/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.string;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;

public final class StringSplitPartFunction
extends Scalar<String, Object> {
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar("split_part", DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.INTEGER.getTypeSignature(), DataTypes.STRING.getTypeSignature()), StringSplitPartFunction::new);
    }

    public StringSplitPartFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object>[] args) {
        assert (args.length == 3) : "split_part takes exactly three arguments";
        String text = (String)args[0].value();
        String delimiter = (String)args[1].value();
        Integer indexB = (Integer)args[2].value();
        if (text == null || delimiter == null || indexB == null) {
            return null;
        }
        int index = indexB;
        if (index < 1) {
            throw new IllegalArgumentException("index in split_part must be greater than zero");
        }
        if (delimiter.isEmpty()) {
            if (index == 1) {
                return text;
            }
            return "";
        }
        int startIndex = 0;
        for (int i = 1; i < index; ++i) {
            int pos = text.indexOf(delimiter, startIndex);
            if (pos < 0) {
                return "";
            }
            startIndex = pos + delimiter.length();
        }
        int endIndex = text.indexOf(delimiter, startIndex);
        if (endIndex < 0) {
            endIndex = text.length();
        }
        return text.substring(startIndex, endIndex);
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }
}

