/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.string;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.scalar.ThreeParametersFunction;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.util.Locale;

public class StringPaddingFunction
extends Scalar<String, Object> {
    public static final String LNAME = "lpad";
    public static final String RNAME = "rpad";
    public static final String DEFAULT_FILL = " ";
    public static final int LEN_LIMIT = 50000;
    private final Signature signature;
    private final Signature boundSignature;
    private final ThreeParametersFunction<char[], Integer, char[], String> func;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(LNAME, DataTypes.STRING.getTypeSignature(), DataTypes.INTEGER.getTypeSignature(), DataTypes.STRING.getTypeSignature()), (signature, boundSignature) -> new StringPaddingFunction((Signature)signature, (Signature)boundSignature, StringPaddingFunction::lpad));
        module.register(Signature.scalar(LNAME, DataTypes.STRING.getTypeSignature(), DataTypes.INTEGER.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()), (signature, boundSignature) -> new StringPaddingFunction((Signature)signature, (Signature)boundSignature, StringPaddingFunction::lpad));
        module.register(Signature.scalar(RNAME, DataTypes.STRING.getTypeSignature(), DataTypes.INTEGER.getTypeSignature(), DataTypes.STRING.getTypeSignature()), (signature, boundSignature) -> new StringPaddingFunction((Signature)signature, (Signature)boundSignature, StringPaddingFunction::rpad));
        module.register(Signature.scalar(RNAME, DataTypes.STRING.getTypeSignature(), DataTypes.INTEGER.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()), (signature, boundSignature) -> new StringPaddingFunction((Signature)signature, (Signature)boundSignature, StringPaddingFunction::rpad));
    }

    private StringPaddingFunction(Signature signature, Signature boundSignature, ThreeParametersFunction<char[], Integer, char[], String> func) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.func = func;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
        String fill;
        assert (args.length == 2 || args.length == 3) : String.format(Locale.ENGLISH, "number of arguments must be 2 (optionally 3), got %d instead", args.length);
        String str = (String)args[0].value();
        Number len = (Number)args[1].value();
        String string = fill = args.length == 3 ? (String)args[2].value() : DEFAULT_FILL;
        if (str == null || len == null || fill == null) {
            return null;
        }
        int lenValue = len.intValue();
        if (lenValue > 50000) {
            throw new IllegalArgumentException(String.format(Locale.ENGLISH, "len argument exceeds predefined limit of %d", 50000));
        }
        if (lenValue <= 0 || str.isEmpty() && fill.isEmpty()) {
            return "";
        }
        if (str.length() >= lenValue) {
            return str.substring(0, lenValue);
        }
        if (fill.isEmpty()) {
            return str;
        }
        return this.func.apply(str.toCharArray(), lenValue, fill.toCharArray());
    }

    private static String lpad(char[] srcChars, int len, char[] fillChars) {
        char[] buffer = new char[len];
        int padLen = len - srcChars.length;
        System.arraycopy(srcChars, 0, buffer, padLen, srcChars.length);
        for (int i = 0; i < padLen; ++i) {
            buffer[i] = fillChars[i % fillChars.length];
        }
        return String.valueOf(buffer);
    }

    private static String rpad(char[] srcChars, int len, char[] fillChars) {
        char[] buffer = new char[len];
        System.arraycopy(srcChars, 0, buffer, 0, srcChars.length);
        int i = srcChars.length;
        int j = 0;
        while (i < len) {
            buffer[i] = fillChars[j % fillChars.length];
            ++i;
            ++j;
        }
        return String.valueOf(buffer);
    }
}

