/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.string;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.util.Locale;
import java.util.function.BiFunction;

public class StringLeftRightFunction
extends Scalar<String, Object> {
    private final Signature signature;
    private final Signature boundSignature;
    private final BiFunction<String, Integer, String> func;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar("left", DataTypes.STRING.getTypeSignature(), DataTypes.INTEGER.getTypeSignature(), DataTypes.STRING.getTypeSignature()), (signature, boundSignature) -> new StringLeftRightFunction((Signature)signature, (Signature)boundSignature, StringLeftRightFunction::left));
        module.register(Signature.scalar("right", DataTypes.STRING.getTypeSignature(), DataTypes.INTEGER.getTypeSignature(), DataTypes.STRING.getTypeSignature()), (signature, boundSignature) -> new StringLeftRightFunction((Signature)signature, (Signature)boundSignature, StringLeftRightFunction::right));
    }

    private StringLeftRightFunction(Signature signature, Signature boundSignature, BiFunction<String, Integer, String> func) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.func = func;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
        assert (args.length == 2) : String.format(Locale.ENGLISH, "number of arguments must be 2, got %d instead", args.length);
        String str = (String)args[0].value();
        Number len = (Number)args[1].value();
        if (str == null || len == null) {
            return null;
        }
        return len.intValue() == 0 || str.isEmpty() ? "" : this.func.apply(str, len.intValue());
    }

    private static String left(String str, int len) {
        if (len > 0) {
            return str.substring(0, Math.min(len, str.length()));
        }
        int finalLen = str.length() + len;
        return finalLen > 0 ? str.substring(0, finalLen) : "";
    }

    private static String right(String str, int len) {
        if (len < 0) {
            return str.substring(Math.min(-len, str.length()));
        }
        int finalLen = str.length() - len;
        return finalLen <= 0 ? str : str.substring(finalLen);
    }
}

