/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.string;

import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;

public final class InitCapFunction {
    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar("initcap", DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()), (signature, boundSignature) -> new UnaryScalar<String, String>((Signature)signature, (Signature)boundSignature, DataTypes.STRING, InitCapFunction::toCapital));
    }

    private static String toCapital(String val) {
        int cp;
        if (val.length() == 0) {
            return val;
        }
        char[] chars = new char[val.length()];
        boolean wordStarts = true;
        int j = 0;
        for (int i = 0; i < val.length(); i += Character.charCount(cp)) {
            cp = val.codePointAt(i);
            if (Character.isSpaceChar(cp)) {
                chars[j++] = val.charAt(i);
                wordStarts = true;
                continue;
            }
            if (wordStarts) {
                chars[j++] = (char)Character.toUpperCase(cp);
                wordStarts = false;
                continue;
            }
            chars[j++] = (char)Character.toLowerCase(cp);
        }
        return new String(chars);
    }
}

