/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.string;

import io.crate.common.Hex;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.nio.charset.StandardCharsets;
import java.security.DigestException;
import java.security.MessageDigest;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.common.hash.MessageDigests;

public final class HashFunctions {
    public static void register(ScalarFunctionModule module) {
        HashFunctions.register(module, "md5", HashMethod.MD5::digest);
        HashFunctions.register(module, "sha1", HashMethod.SHA1::digest);
    }

    private static void register(ScalarFunctionModule module, String name, Function<String, String> func) {
        module.register(Signature.scalar(name, DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()), (signature, boundSignature) -> new UnaryScalar((Signature)signature, (Signature)boundSignature, DataTypes.STRING, func));
    }

    private static enum HashMethod {
        MD5(MessageDigests::md5),
        SHA1(MessageDigests::sha1);

        private final Supplier<MessageDigest> messageDigestSupplier;

        private HashMethod(Supplier<MessageDigest> digestSupplier) {
            this.messageDigestSupplier = digestSupplier;
        }

        public String digest(String input) {
            MessageDigest messageDigest = this.messageDigestSupplier.get();
            byte[] digest = new byte[messageDigest.getDigestLength()];
            messageDigest.update(input.getBytes(StandardCharsets.UTF_8));
            try {
                messageDigest.digest(digest, 0, digest.length);
            }
            catch (DigestException e) {
                throw new RuntimeException("Error computing digest.", e);
            }
            return Hex.encodeHexString(digest);
        }
    }
}

