/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.string;

import io.crate.common.Hex;
import io.crate.common.Octal;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.scalar.arithmetic.BinaryScalar;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Locale;
import java.util.function.BinaryOperator;
import java.util.function.Function;

public class EncodeDecodeFunction {
    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar("encode", DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()), (signature, boundSignature) -> new BinaryScalar<String>(new Encode(), (Signature)signature, (Signature)boundSignature, DataTypes.STRING));
        module.register(Signature.scalar("decode", DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()), (signature, boundSignature) -> new BinaryScalar<String>(new Decode(), (Signature)signature, (Signature)boundSignature, DataTypes.STRING));
    }

    private static class Decode
    implements BinaryOperator<String> {
        private Decode() {
        }

        @Override
        public String apply(String text, String format) {
            Format fmt;
            try {
                fmt = Format.valueOf(format.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Encoding format '%s' is not supported", format));
            }
            return fmt.decode(text);
        }
    }

    private static class Encode
    implements BinaryOperator<String> {
        private Encode() {
        }

        @Override
        public String apply(String bytea, String format) {
            Format fmt;
            try {
                fmt = Format.valueOf(format.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Encoding format '%s' is not supported", format));
            }
            return fmt.encode(bytea);
        }
    }

    private static enum Format {
        BASE64(bytea -> {
            byte[] text = Hex.isHexFormat(bytea) ? Hex.decodeHex(Hex.stripHexFormatFlag(bytea)) : Octal.decode(bytea);
            return Base64.getEncoder().encodeToString(text);
        }, text -> {
            byte[] value = Base64.getDecoder().decode(text.getBytes(StandardCharsets.UTF_8));
            return "\\x" + Hex.encodeHexString(value);
        }),
        HEX(bytea -> {
            if (Hex.isHexFormat(bytea)) {
                return Hex.stripHexFormatFlag(bytea);
            }
            return Hex.encodeHexString(Octal.decode(bytea));
        }, text -> "\\x" + Hex.validateHex(text, 0)),
        ESCAPE(bytea -> {
            if (Hex.isHexFormat(bytea)) {
                return Octal.encode(Hex.decodeHex(Hex.stripHexFormatFlag(bytea)));
            }
            return Octal.encode(bytea.getBytes(StandardCharsets.UTF_8));
        }, text -> "\\x" + Hex.encodeHexString(Octal.decode(text)));

        private final Function<String, String> encode;
        private final Function<String, String> decode;

        private Format(Function<String, String> encode, Function<String, String> decode) {
            this.encode = encode;
            this.decode = decode;
        }

        String encode(String bytea) {
            return this.encode.apply(bytea);
        }

        String decode(String text) {
            return this.decode.apply(text);
        }
    }
}

