/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.string;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;

public final class ChrFunction
extends Scalar<String, Object> {
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar("chr", DataTypes.INTEGER.getTypeSignature(), DataTypes.STRING.getTypeSignature()), ChrFunction::new);
    }

    public ChrFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object>[] args) {
        assert (args.length == 1) : "chr takes exactly one argument";
        Object value = args[0].value();
        if (value == null) {
            return null;
        }
        int character = (Integer)value;
        if (character == 0) {
            throw new IllegalArgumentException("null character not permitted");
        }
        if (character > 0x10FFFF || character < 0) {
            throw new IllegalArgumentException("requested character too large for encoding: " + character);
        }
        return Character.toString((char)character);
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }
}

