/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.regex;

import io.crate.data.Input;
import io.crate.expression.RegexpFlags;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class RegexpReplaceFunction
extends Scalar<String, String> {
    public static final String NAME = "regexp_replace";
    @Nullable
    private final Pattern pattern;
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(NAME, DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()), RegexpReplaceFunction::new);
        module.register(Signature.scalar(NAME, DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.STRING.getTypeSignature()), RegexpReplaceFunction::new);
    }

    private RegexpReplaceFunction(Signature signature, Signature boundSignature) {
        this(signature, boundSignature, null);
    }

    private RegexpReplaceFunction(Signature signature, Signature boundSignature, @Nullable Pattern pattern) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.pattern = pattern;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, TransactionContext txnCtx, NodeContext nodeCtx) {
        return RegexpReplaceFunction.evaluateIfLiterals(this, txnCtx, nodeCtx, symbol);
    }

    @Override
    public Scalar<String, String> compile(List<Symbol> arguments) {
        assert (arguments.size() >= 3) : "number of arguments muts be >= 3";
        Symbol patternSymbol = arguments.get(1);
        if (patternSymbol instanceof Input) {
            Symbol flagsSymbol;
            String pattern = (String)((Input)((Object)patternSymbol)).value();
            if (pattern == null) {
                return this;
            }
            if (arguments.size() == 4 && (flagsSymbol = arguments.get(3)) instanceof Input) {
                String flags = (String)((Input)((Object)flagsSymbol)).value();
                return new RegexpReplaceFunction(this.signature, this.boundSignature, Pattern.compile(pattern, RegexpFlags.parseFlags(flags)));
            }
        }
        return this;
    }

    @Override
    public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<String>[] args) {
        assert (args.length == 3 || args.length == 4) : "number of args must be 3 or 4";
        String value = args[0].value();
        String pattern = args[1].value();
        String replacement = args[2].value();
        if (value == null || pattern == null || replacement == null) {
            return null;
        }
        String flags = null;
        if (args.length == 4) {
            flags = args[3].value();
        }
        Pattern replacePattern = this.pattern == null ? Pattern.compile(pattern, RegexpFlags.parseFlags(flags)) : this.pattern;
        Matcher m = replacePattern.matcher(value);
        return RegexpFlags.isGlobal(flags) ? m.replaceAll(replacement) : m.replaceFirst(replacement);
    }
}

