/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.postgres;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.FunctionName;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;

public class PgBackendPidFunction
extends Scalar<Integer, Void> {
    public static final String NAME = "pg_backend_pid";
    private static final FunctionName FQN = new FunctionName("pg_catalog", "pg_backend_pid");
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(FQN, DataTypes.INTEGER.getTypeSignature()).withFeatures(NO_FEATURES), PgBackendPidFunction::new);
    }

    public PgBackendPidFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, TransactionContext txnCtx, NodeContext nodeCtx) {
        assert (symbol.arguments().size() == 0) : "function's number of arguments must be 0";
        return Literal.of(-1);
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Integer evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
        assert (args.length == 0) : "number of args must be 0";
        return -1;
    }
}

