/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.geo;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.geo.GeoJSONUtils;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.List;
import java.util.Map;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.SpatialRelation;

public class WithinFunction
extends Scalar<Boolean, Object> {
    public static final String NAME = "within";
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(NAME, DataTypes.GEO_SHAPE.getTypeSignature(), DataTypes.GEO_SHAPE.getTypeSignature(), DataTypes.BOOLEAN.getTypeSignature()), WithinFunction::new);
        for (DataType dataType : List.of(DataTypes.GEO_SHAPE, DataTypes.STRING, DataTypes.UNTYPED_OBJECT, DataTypes.UNDEFINED)) {
            module.register(Signature.scalar(NAME, DataTypes.GEO_POINT.getTypeSignature(), dataType.getTypeSignature(), DataTypes.BOOLEAN.getTypeSignature()).withForbiddenCoercion(), WithinFunction::new);
        }
    }

    private WithinFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
        assert (args.length == 2) : "number of args must be 2";
        return this.evaluate(args[0], args[1]);
    }

    public Boolean evaluate(Input leftInput, Input rightInput) {
        Object left = leftInput.value();
        if (left == null) {
            return null;
        }
        Object right = rightInput.value();
        if (right == null) {
            return null;
        }
        return WithinFunction.parseLeftShape(left).relate(this.parseRightShape(right)) == SpatialRelation.WITHIN;
    }

    private static Shape parseLeftShape(Object left) {
        Shape shape;
        if (left instanceof Point) {
            Point point = (Point)left;
            shape = SpatialContext.GEO.getShapeFactory().pointXY(point.getX(), point.getY());
        } else if (left instanceof Double[]) {
            Double[] values = (Double[])left;
            shape = SpatialContext.GEO.getShapeFactory().pointXY(values[0].doubleValue(), values[1].doubleValue());
        } else {
            shape = left instanceof String ? GeoJSONUtils.wkt2Shape((String)left) : GeoJSONUtils.map2Shape((Map)left);
        }
        return shape;
    }

    private Shape parseRightShape(Object right) {
        return right instanceof String ? GeoJSONUtils.wkt2Shape((String)right) : GeoJSONUtils.map2Shape((Map)right);
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, TransactionContext txnCtx, NodeContext nodeCtx) {
        Symbol left = symbol.arguments().get(0);
        Symbol right = symbol.arguments().get(1);
        int numLiterals = 0;
        if (left.symbolType().isValueSymbol()) {
            numLiterals = (short)(numLiterals + 1);
        }
        if (right.symbolType().isValueSymbol()) {
            numLiterals = (short)(numLiterals + 1);
        }
        if (numLiterals == 2) {
            return Literal.of(this.evaluate((Input)((Object)left), (Input)((Object)right)));
        }
        return symbol;
    }
}

