/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.geo;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.geo.GeoJSONUtils;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.util.Map;
import org.locationtech.spatial4j.shape.Shape;

public class IntersectsFunction
extends Scalar<Boolean, Object> {
    public static final String NAME = "intersects";
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(NAME, DataTypes.GEO_SHAPE.getTypeSignature(), DataTypes.GEO_SHAPE.getTypeSignature(), DataTypes.BOOLEAN.getTypeSignature()), IntersectsFunction::new);
    }

    public IntersectsFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Boolean evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        assert (args.length == 2) : "Invalid number of Arguments";
        Object left = args[0].value();
        if (left == null) {
            return null;
        }
        Object right = args[1].value();
        if (right == null) {
            return null;
        }
        Shape leftShape = GeoJSONUtils.map2Shape((Map<String, Object>)DataTypes.GEO_SHAPE.sanitizeValue(left));
        Shape rightShape = GeoJSONUtils.map2Shape((Map<String, Object>)DataTypes.GEO_SHAPE.sanitizeValue(right));
        return leftShape.relate(rightShape).intersects();
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, TransactionContext txnCtx, NodeContext nodeCtx) {
        Symbol left = symbol.arguments().get(0);
        Symbol right = symbol.arguments().get(1);
        int numLiterals = 0;
        if (left.symbolType().isValueSymbol()) {
            ++numLiterals;
        }
        if (right.symbolType().isValueSymbol()) {
            ++numLiterals;
        }
        if (numLiterals == 2) {
            return Literal.of((Boolean)this.evaluate(txnCtx, nodeCtx, new Input[]{(Input)((Object)left), (Input)((Object)right)}));
        }
        return symbol;
    }
}

