/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.geo;

import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.GeoPointType;
import org.elasticsearch.common.geo.GeoHashUtils;
import org.locationtech.spatial4j.shape.Point;

public final class GeoHashFunction {
    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar("geohash", DataTypes.GEO_POINT.getTypeSignature(), DataTypes.STRING.getTypeSignature()), (signature, boundSignature) -> new UnaryScalar<String, Point>((Signature)signature, (Signature)boundSignature, DataTypes.GEO_POINT, GeoHashFunction::getGeoHash));
    }

    private static String getGeoHash(Object value) {
        Point geoValue = GeoPointType.INSTANCE.sanitizeValue(value);
        return GeoHashUtils.stringEncode(geoValue.getX(), geoValue.getY());
    }
}

