/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.geo;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.util.Arrays;
import org.elasticsearch.common.geo.GeoUtils;
import org.locationtech.spatial4j.shape.Point;

public class DistanceFunction
extends Scalar<Double, Point> {
    public static final String NAME = "distance";
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(NAME, DataTypes.GEO_POINT.getTypeSignature(), DataTypes.GEO_POINT.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature()), DistanceFunction::new);
    }

    private DistanceFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Double evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Point>[] args) {
        assert (args.length == 2) : "number of args must be 2";
        return DistanceFunction.evaluate(args[0], args[1]);
    }

    public static Double evaluate(Input<Point> arg1, Input<Point> arg2) {
        Point value1 = arg1.value();
        if (value1 == null) {
            return null;
        }
        Point value2 = arg2.value();
        if (value2 == null) {
            return null;
        }
        return GeoUtils.arcDistance(value1.getY(), value1.getX(), value2.getY(), value2.getX());
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, TransactionContext txnCtx, NodeContext nodeCtx) {
        Symbol arg1 = symbol.arguments().get(0);
        Symbol arg2 = symbol.arguments().get(1);
        DataType<?> arg1Type = arg1.valueType();
        DataType<?> arg2Type = arg2.valueType();
        boolean arg1IsReference = true;
        int numLiterals = 0;
        if (arg1.symbolType().isValueSymbol()) {
            numLiterals = (short)(numLiterals + 1);
            arg1IsReference = false;
        }
        if (arg2.symbolType().isValueSymbol()) {
            numLiterals = (short)(numLiterals + 1);
        }
        if (numLiterals == 2) {
            return Literal.of(DistanceFunction.evaluate((Input)((Object)arg1), (Input)((Object)arg2)));
        }
        if (!arg1IsReference) {
            return new Function(this.signature, Arrays.asList(arg2, arg1), this.signature.getReturnType().createType());
        }
        return symbol;
    }
}

