/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.geo;

import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import org.locationtech.spatial4j.shape.Point;

public final class CoordinateFunction {
    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar("latitude", DataTypes.GEO_POINT.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature()), (signature, boundSignature) -> new UnaryScalar<Double, Point>((Signature)signature, (Signature)boundSignature, DataTypes.GEO_POINT, CoordinateFunction::getLatitude));
        module.register(Signature.scalar("longitude", DataTypes.GEO_POINT.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature()), (signature, boundSignature) -> new UnaryScalar<Double, Point>((Signature)signature, (Signature)boundSignature, DataTypes.GEO_POINT, CoordinateFunction::getLongitude));
    }

    private static Double getLatitude(Object value) {
        return DataTypes.GEO_POINT.sanitizeValue(value).getY();
    }

    private static Double getLongitude(Object value) {
        return DataTypes.GEO_POINT.sanitizeValue(value).getX();
    }
}

