/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.formatting;

import io.crate.common.StringUtils;
import io.crate.common.collections.Lists2;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.TextStyle;
import java.time.temporal.IsoFields;
import java.time.temporal.JulianFields;
import java.time.temporal.TemporalField;
import java.time.temporal.WeekFields;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.common.Strings;

public class DateTimeFormatter {
    private static final TokenNode ROOT_TOKEN_NODE = new TokenNode();
    private final List<Object> tokens;
    private static final TemporalField WEEK_OF_YEAR;

    public DateTimeFormatter(String pattern) {
        this.tokens = DateTimeFormatter.parse(pattern);
    }

    private static List<Object> parse(String pattern) {
        ArrayList<Object> tokens = new ArrayList<Object>();
        String pattern_to_consume = pattern;
        int idx = 0;
        TokenNode currentTokenNode = ROOT_TOKEN_NODE;
        while (idx <= pattern_to_consume.length() && pattern_to_consume.length() > 0) {
            TokenNode nextTokenNode = idx == pattern_to_consume.length() ? null : currentTokenNode.children.get(Character.valueOf(pattern_to_consume.charAt(idx)));
            if (nextTokenNode == null && idx > 0) {
                if (currentTokenNode.isTokenNode()) {
                    tokens.add((Object)currentTokenNode.token);
                } else {
                    int depth;
                    for (depth = idx; depth > 0; --depth) {
                        currentTokenNode = currentTokenNode.parent;
                        if (!currentTokenNode.isTokenNode()) continue;
                        tokens.add((Object)currentTokenNode.token);
                        break;
                    }
                    tokens.add(pattern_to_consume.substring(depth, idx));
                }
                pattern_to_consume = pattern_to_consume.substring(idx);
                currentTokenNode = ROOT_TOKEN_NODE;
                idx = 0;
                continue;
            }
            if (nextTokenNode == null) {
                tokens.add(pattern_to_consume.substring(0, idx + 1));
                pattern_to_consume = pattern_to_consume.substring(idx + 1);
                continue;
            }
            ++idx;
            currentTokenNode = nextTokenNode;
        }
        return tokens;
    }

    public String format(LocalDateTime datetime) {
        return Lists2.joinOn("", this.tokens, x -> {
            if (x instanceof Token) {
                return DateTimeFormatter.getElement((Token)((Object)((Object)x)), datetime);
            }
            return String.valueOf(x);
        });
    }

    private static String getElement(Token token, LocalDateTime datetime) {
        String element = switch (token) {
            case Token.HOUR_OF_DAY, Token.HOUR_OF_DAY12 -> {
                if (datetime.getHour() >= 12) {
                    yield Strings.padStart(String.valueOf(datetime.getHour() - 12), 2, '0');
                }
                yield Strings.padStart(String.valueOf(datetime.getHour()), 2, '0');
            }
            case Token.HOUR_OF_DAY24 -> Strings.padStart(String.valueOf(datetime.getHour()), 2, '0');
            case Token.MINUTE -> Strings.padStart(String.valueOf(datetime.getMinute()), 2, '0');
            case Token.SECOND -> Strings.padStart(String.valueOf(datetime.getSecond()), 2, '0');
            case Token.MILLISECOND -> Strings.padStart(String.valueOf(datetime.getNano() / 1000000), 3, '0');
            case Token.MICROSECOND -> Strings.padStart(String.valueOf(datetime.getNano() / 1000), 6, '0');
            case Token.TENTH_OF_SECOND -> datetime.getNano() / 100000000;
            case Token.HUNDREDTH_OF_SECOND -> datetime.getNano() / 10000000;
            case Token.MILLISECOND_FF -> datetime.getNano() / 1000000;
            case Token.TENTH_OF_MILLISECOND -> datetime.getNano() / 100000;
            case Token.HUNDREDTH_OF_MILLISECOND -> datetime.getNano() / 10000;
            case Token.MICROSECOND_FF -> datetime.getNano() / 1000;
            case Token.SECONDS_PAST_MIDNIGHT, Token.SECONDS_PAST_MIDNIGHT_S -> {
                Instant midnight = datetime.toLocalDate().atStartOfDay().toInstant(ZoneOffset.UTC);
                yield String.valueOf(Duration.between(midnight, datetime.toInstant(ZoneOffset.UTC)).getSeconds());
            }
            case Token.AM_UPPER, Token.PM_UPPER -> {
                if (datetime.getHour() >= 12) {
                    yield "PM";
                }
                yield "AM";
            }
            case Token.AM_LOWER, Token.PM_LOWER -> {
                if (datetime.getHour() >= 12) {
                    yield "pm";
                }
                yield "am";
            }
            case Token.A_M_UPPER, Token.P_M_UPPER -> {
                if (datetime.getHour() >= 12) {
                    yield "P.M.";
                }
                yield "A.M.";
            }
            case Token.A_M_LOWER, Token.P_M_LOWER -> {
                if (datetime.getHour() >= 12) {
                    yield "p.m.";
                }
                yield "a.m.";
            }
            case Token.YEAR_WITH_COMMA -> {
                String s = String.valueOf(datetime.getYear());
                yield s.substring(0, 1) + "," + s.substring(1);
            }
            case Token.YEAR_YYYY -> Strings.padStart(String.valueOf(datetime.getYear()), 4, '0');
            case Token.YEAR_YYY -> {
                String s = Strings.padStart(String.valueOf(datetime.getYear()), 4, '0');
                yield s.substring(s.length() - 3);
            }
            case Token.YEAR_YY -> {
                String s = Strings.padStart(String.valueOf(datetime.getYear()), 4, '0');
                yield s.substring(s.length() - 2);
            }
            case Token.YEAR_Y -> {
                String s = Strings.padStart(String.valueOf(datetime.getYear()), 4, '0');
                yield s.substring(s.length() - 1);
            }
            case Token.ISO_YEAR_YYY -> String.valueOf(datetime.get(IsoFields.WEEK_BASED_YEAR));
            case Token.ISO_YEAR_YY -> {
                String s = String.valueOf(datetime.get(IsoFields.WEEK_BASED_YEAR));
                yield s.substring(s.length() - 3);
            }
            case Token.ISO_YEAR_Y -> {
                String s = String.valueOf(datetime.get(IsoFields.WEEK_BASED_YEAR));
                yield s.substring(s.length() - 2);
            }
            case Token.ISO_YEAR -> {
                String s = String.valueOf(datetime.get(IsoFields.WEEK_BASED_YEAR));
                yield s.substring(s.length() - 1);
            }
            case Token.BC_ERA_UPPER, Token.AD_ERA_UPPER -> {
                if (datetime.getYear() >= 1) {
                    yield "AD";
                }
                yield "BC";
            }
            case Token.BC_ERA_LOWER, Token.AD_ERA_LOWER -> {
                if (datetime.getYear() >= 1) {
                    yield "ad";
                }
                yield "bc";
            }
            case Token.B_C_ERA_UPPER, Token.A_D_ERA_UPPER -> {
                if (datetime.getYear() >= 1) {
                    yield "A.D";
                }
                yield "B.C";
            }
            case Token.B_C_ERA_LOWER, Token.A_D_ERA_LOWER -> {
                if (datetime.getYear() >= 1) {
                    yield "a.d";
                }
                yield "b.c";
            }
            case Token.MONTH_UPPER -> StringUtils.padEnd(datetime.getMonth().getDisplayName(TextStyle.FULL, Locale.ENGLISH), 7, ' ').toUpperCase(Locale.ENGLISH);
            case Token.MONTH_CAPITALIZED -> StringUtils.capitalize(StringUtils.padEnd(datetime.getMonth().getDisplayName(TextStyle.FULL, Locale.ENGLISH), 7, ' '));
            case Token.MONTH_LOWER -> StringUtils.padEnd(datetime.getMonth().getDisplayName(TextStyle.FULL, Locale.ENGLISH), 7, ' ').toLowerCase(Locale.ENGLISH);
            case Token.ABBREVIATED_MONTH_UPPER -> datetime.getMonth().getDisplayName(TextStyle.SHORT, Locale.ENGLISH).toUpperCase(Locale.ENGLISH);
            case Token.ABBREVIATED_MONTH_CAPITALIZED -> StringUtils.capitalize(datetime.getMonth().getDisplayName(TextStyle.SHORT, Locale.ENGLISH));
            case Token.ABBREVIATED_MONTH_LOWER -> datetime.getMonth().getDisplayName(TextStyle.SHORT, Locale.ENGLISH).toLowerCase(Locale.ENGLISH);
            case Token.MONTH_NUMBER -> Strings.padStart(String.valueOf(datetime.getMonth().getValue()), 2, '0');
            case Token.DAY_UPPER -> StringUtils.padEnd(datetime.getDayOfWeek().getDisplayName(TextStyle.FULL, Locale.ENGLISH), 8, ' ').toUpperCase(Locale.ENGLISH);
            case Token.DAY_CAPITALIZED -> StringUtils.padEnd(StringUtils.capitalize(datetime.getDayOfWeek().getDisplayName(TextStyle.FULL, Locale.ENGLISH)), 8, ' ');
            case Token.DAY_LOWER -> StringUtils.padEnd(datetime.getDayOfWeek().getDisplayName(TextStyle.FULL, Locale.ENGLISH), 8, ' ').toLowerCase(Locale.ENGLISH);
            case Token.ABBREVIATED_DAY_UPPER -> datetime.getDayOfWeek().getDisplayName(TextStyle.SHORT, Locale.ENGLISH).toUpperCase(Locale.ENGLISH);
            case Token.ABBREVIATED_DAY_CAPITALIZED -> StringUtils.capitalize(datetime.getDayOfWeek().getDisplayName(TextStyle.SHORT, Locale.ENGLISH));
            case Token.ABBREVIATED_DAY_LOWER -> datetime.getDayOfWeek().getDisplayName(TextStyle.SHORT, Locale.ENGLISH).toLowerCase(Locale.ENGLISH);
            case Token.DAY_OF_YEAR -> Strings.padStart(String.valueOf(datetime.getDayOfYear()), 3, '0');
            case Token.DAY_OF_ISO_WEEK_NUMBERING_YEAR -> Strings.padStart(String.valueOf((datetime.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR) - 1) * 7 + datetime.getDayOfWeek().getValue()), 3, '0');
            case Token.DAY_OF_MONTH -> Strings.padStart(String.valueOf(datetime.getDayOfMonth()), 2, '0');
            case Token.DAY_OF_WEEK -> datetime.getDayOfWeek().getValue() % 7 + 1;
            case Token.ISO_DAY_OF_WEEK -> datetime.getDayOfWeek().getValue();
            case Token.WEEK_OF_MONTH -> datetime.getDayOfMonth() / 7 + 1;
            case Token.WEEK_NUMBER_OF_YEAR -> Strings.padStart(String.valueOf(datetime.get(WEEK_OF_YEAR)), 2, '0');
            case Token.WEEK_NUMBER_OF_ISO_YEAR -> Strings.padStart(String.valueOf(datetime.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR)), 2, '0');
            case Token.CENTURY -> (datetime.getYear() - 1) / 100 + 1;
            case Token.JULIAN_DAY -> datetime.getLong(JulianFields.JULIAN_DAY);
            case Token.QUARTER -> (datetime.getMonthValue() + 2) / 3;
            case Token.ROMAN_MONTH_UPPER -> StringUtils.padEnd(DateTimeFormatter.toRoman(datetime.getMonthValue()).toUpperCase(Locale.ENGLISH), 4, ' ');
            case Token.ROMAN_MONTH_LOWER -> StringUtils.padEnd(DateTimeFormatter.toRoman(datetime.getMonthValue()).toLowerCase(Locale.ENGLISH), 4, ' ');
            case Token.TIMEZONE_UPPER, Token.TIMEZONE_LOWER, Token.TIMEZONE_HOURS, Token.TIMEZONE_MINUTES, Token.TIMEZONE_OFFSET_FROM_UTC -> "";
            default -> "";
        };
        return String.valueOf(element);
    }

    private static String toRoman(int number) {
        int[] romanN = new int[]{10, 9, 5, 4, 1};
        String[] romanS = new String[]{"X", "IX", "V", "IV", "I"};
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < romanN.length; ++i) {
            while (number >= romanN[i]) {
                sb.append(romanS[i]);
                number -= romanN[i];
            }
        }
        return sb.toString();
    }

    static {
        for (Token token : Token.values()) {
            ROOT_TOKEN_NODE.addChild(token);
        }
        WEEK_OF_YEAR = WeekFields.of(Locale.ENGLISH).weekOfWeekBasedYear();
    }

    static class TokenNode {
        private final Map<Character, TokenNode> children = new HashMap<Character, TokenNode>();
        private Token token;
        public final TokenNode parent;

        public TokenNode() {
            this.token = null;
            this.parent = null;
        }

        private TokenNode(String tokenString, Token token, TokenNode parent) {
            this.parent = parent;
            if (tokenString.length() == 1) {
                this.token = token;
            } else {
                this.token = null;
                this.addChild(tokenString.substring(1), token);
            }
        }

        public void addChild(Token token) {
            this.addChild(token.toString(), token);
        }

        private void addChild(String tokenString, Token token) {
            TokenNode child = this.children.get(Character.valueOf(tokenString.charAt(0)));
            if (child == null) {
                this.children.put(Character.valueOf(tokenString.charAt(0)), new TokenNode(tokenString, token, this));
            } else if (tokenString.length() == 1) {
                child.token = token;
            } else {
                child.addChild(tokenString.substring(1), token);
            }
        }

        public boolean isTokenNode() {
            return this.token != null;
        }

        public boolean isRootNode() {
            return this.parent == null;
        }
    }

    private static enum Token {
        HOUR_OF_DAY("HH"),
        HOUR_OF_DAY12("HH12"),
        HOUR_OF_DAY24("HH24"),
        MINUTE("MI"),
        SECOND("SS"),
        MILLISECOND("MS"),
        MICROSECOND("US"),
        TENTH_OF_SECOND("FF1"),
        HUNDREDTH_OF_SECOND("FF2"),
        MILLISECOND_FF("FF3"),
        TENTH_OF_MILLISECOND("FF4"),
        HUNDREDTH_OF_MILLISECOND("FF5"),
        MICROSECOND_FF("FF6"),
        SECONDS_PAST_MIDNIGHT("SSSS"),
        SECONDS_PAST_MIDNIGHT_S("SSSSS"),
        AM_UPPER("AM"),
        AM_LOWER("am"),
        PM_UPPER("PM"),
        PM_LOWER("pm"),
        A_M_UPPER("A.M."),
        A_M_LOWER("a.m."),
        P_M_UPPER("P.M."),
        P_M_LOWER("p.m."),
        YEAR_WITH_COMMA("Y,YYY"),
        YEAR_YYYY("YYYY"),
        YEAR_YYY("YYY"),
        YEAR_YY("YY"),
        YEAR_Y("Y"),
        ISO_YEAR_YYY("IYYY"),
        ISO_YEAR_YY("IYY"),
        ISO_YEAR_Y("IY"),
        ISO_YEAR("I"),
        BC_ERA_UPPER("BC"),
        BC_ERA_LOWER("bc"),
        AD_ERA_UPPER("AD"),
        AD_ERA_LOWER("ad"),
        B_C_ERA_UPPER("B.C"),
        B_C_ERA_LOWER("b.c"),
        A_D_ERA_UPPER("A.D"),
        A_D_ERA_LOWER("a.d"),
        MONTH_UPPER("MONTH"),
        MONTH_CAPITALIZED("Month"),
        MONTH_LOWER("month"),
        ABBREVIATED_MONTH_UPPER("MON"),
        ABBREVIATED_MONTH_CAPITALIZED("Mon"),
        ABBREVIATED_MONTH_LOWER("mon"),
        MONTH_NUMBER("MM"),
        DAY_UPPER("DAY"),
        DAY_CAPITALIZED("Day"),
        DAY_LOWER("day"),
        ABBREVIATED_DAY_UPPER("DY"),
        ABBREVIATED_DAY_CAPITALIZED("Dy"),
        ABBREVIATED_DAY_LOWER("dy"),
        DAY_OF_YEAR("DDD"),
        DAY_OF_ISO_WEEK_NUMBERING_YEAR("IDDD"),
        DAY_OF_MONTH("DD"),
        DAY_OF_WEEK("D"),
        ISO_DAY_OF_WEEK("ID"),
        WEEK_OF_MONTH("W"),
        WEEK_NUMBER_OF_YEAR("WW"),
        WEEK_NUMBER_OF_ISO_YEAR("IW"),
        CENTURY("CC"),
        JULIAN_DAY("J"),
        QUARTER("Q"),
        ROMAN_MONTH_UPPER("RM"),
        ROMAN_MONTH_LOWER("rm"),
        TIMEZONE_UPPER("TZ"),
        TIMEZONE_LOWER("tz"),
        TIMEZONE_HOURS("TZH"),
        TIMEZONE_MINUTES("TZM"),
        TIMEZONE_OFFSET_FROM_UTC("OF");

        private final String token;

        private Token(String token) {
            this.token = token;
        }

        public String toString() {
            return this.token;
        }
    }
}

