/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.cast;

import io.crate.data.Input;
import io.crate.exceptions.ConversionException;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;

public class ImplicitCastFunction
extends Scalar<Object, Object> {
    public static final String NAME = "_cast";
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(NAME, TypeSignature.parseTypeSignature("E"), DataTypes.STRING.getTypeSignature(), DataTypes.UNDEFINED.getTypeSignature()).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E")), ImplicitCastFunction::new);
    }

    private ImplicitCastFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Object evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object>[] args) {
        TypeSignature targetTypeSignature = TypeSignature.parseTypeSignature((String)args[1].value());
        DataType<?> targetType = targetTypeSignature.createType();
        try {
            return targetType.implicitCast(args[0].value());
        }
        catch (ClassCastException | IllegalArgumentException e) {
            throw new ConversionException(args[0].value(), targetType);
        }
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, TransactionContext txnCtx, NodeContext nodeCtx) {
        Symbol argument = symbol.arguments().get(0);
        String targetTypeAsString = (String)((Input)((Object)symbol.arguments().get(1))).value();
        DataType<?> targetType = TypeSignature.parseTypeSignature(targetTypeAsString).createType();
        if (argument.valueType().equals(targetType)) {
            return argument;
        }
        if (argument instanceof Input) {
            Object value = ((Input)((Object)argument)).value();
            try {
                return Literal.ofUnchecked(targetType, targetType.implicitCast(value));
            }
            catch (ClassCastException | IllegalArgumentException e) {
                throw new ConversionException(argument, targetType);
            }
        }
        return symbol;
    }
}

