/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.cast;

import io.crate.data.Input;
import io.crate.exceptions.ConversionException;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataType;
import io.crate.types.TypeSignature;

public class ExplicitCastFunction
extends Scalar<Object, Object> {
    public static final String NAME = "cast";
    private final DataType<?> returnType;
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(NAME, TypeSignature.parseTypeSignature("E"), TypeSignature.parseTypeSignature("V"), TypeSignature.parseTypeSignature("V")).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E"), TypeVariableConstraint.typeVariable("V")), ExplicitCastFunction::new);
    }

    private ExplicitCastFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.returnType = boundSignature.getReturnType().createType();
    }

    @Override
    public Object evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object>[] args) {
        try {
            return this.returnType.explicitCast(args[0].value());
        }
        catch (ClassCastException | IllegalArgumentException e) {
            throw new ConversionException(args[0].value(), this.returnType);
        }
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, TransactionContext txnCtx, NodeContext nodeCtx) {
        Symbol argument = symbol.arguments().get(0);
        if (argument.valueType().equals(this.returnType)) {
            return argument;
        }
        if (argument instanceof Input) {
            Object value = ((Input)((Object)argument)).value();
            try {
                return Literal.ofUnchecked(this.returnType, this.returnType.explicitCast(value));
            }
            catch (ClassCastException | IllegalArgumentException e) {
                throw new ConversionException(argument, this.returnType);
            }
        }
        return symbol;
    }
}

