/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.cast;

import io.crate.exceptions.ConversionException;
import io.crate.expression.scalar.cast.CastMode;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.List;
import java.util.Set;

public class CastFunctionResolver {
    public static final List<String> CAST_FUNCTION_NAMES = List.of("cast", "_cast", "try_cast");

    public static Symbol generateCastFunction(Symbol sourceSymbol, DataType<?> targetType, CastMode ... castModes) {
        Set<CastMode> modes = Set.of(castModes);
        assert (!modes.containsAll(List.of(CastMode.EXPLICIT, CastMode.IMPLICIT))) : "explicit and implicit cast modes are mutually exclusive";
        DataType<?> sourceType = sourceSymbol.valueType();
        if (!sourceType.isConvertableTo(targetType, modes.contains((Object)CastMode.EXPLICIT))) {
            throw new ConversionException(sourceType, targetType);
        }
        if (modes.contains((Object)CastMode.TRY) || modes.contains((Object)CastMode.EXPLICIT)) {
            String name = modes.contains((Object)CastMode.TRY) ? "try_cast" : "cast";
            return new Function(Signature.scalar(name, TypeSignature.parseTypeSignature("E"), TypeSignature.parseTypeSignature("V"), TypeSignature.parseTypeSignature("V")).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E"), TypeVariableConstraint.typeVariable("V")), List.of(sourceSymbol, Literal.of(targetType, null)), targetType);
        }
        return new Function(Signature.scalar("_cast", TypeSignature.parseTypeSignature("E"), DataTypes.STRING.getTypeSignature(), DataTypes.UNDEFINED.getTypeSignature()).withTypeVariableConstraints(TypeVariableConstraint.typeVariable("E")), List.of(sourceSymbol, Literal.of(targetType.getTypeSignature().toString())), targetType);
    }
}

