/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.function.Function;

public final class TruncFunction {
    public static final String NAME = "trunc";

    public static void register(ScalarFunctionModule module) {
        for (DataType<?> type : DataTypes.NUMERIC_PRIMITIVE_TYPES) {
            DataType<?> returnType = DataTypes.getIntegralReturnType(type);
            assert (returnType != null) : "Could not get integral type of " + type;
            module.register(Signature.scalar(NAME, type.getTypeSignature(), returnType.getTypeSignature()).withForbiddenCoercion(), (signature, boundSignature) -> new UnaryScalar<Number, Object>((Signature)signature, (Signature)boundSignature, (DataType<Object>)type, n -> {
                double val = ((Number)n).doubleValue();
                Function<Double, Double> f = val >= 0.0 ? Math::floor : Math::ceil;
                return (Number)returnType.sanitizeValue(f.apply(val));
            }));
        }
        module.register(Signature.scalar(NAME, DataTypes.DOUBLE.getTypeSignature(), DataTypes.INTEGER.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature()), TruncFunction::createTruncWithMode);
    }

    private static Scalar<Number, Number> createTruncWithMode(final Signature signature, final Signature boundSignature) {
        return new Scalar<Number, Number>(){

            @Override
            public Signature signature() {
                return signature;
            }

            @Override
            public Signature boundSignature() {
                return boundSignature;
            }

            @Override
            public Number evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Number> ... args) {
                Number n = args[0].value();
                Number nd = args[1].value();
                if (null == n || null == nd) {
                    return null;
                }
                double val = n.doubleValue();
                int numDecimals = nd.intValue();
                RoundingMode mode = val >= 0.0 ? RoundingMode.FLOOR : RoundingMode.CEILING;
                return BigDecimal.valueOf(val).setScale(numDecimals, mode).doubleValue();
            }
        };
    }
}

