/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.expression.scalar.DoubleScalar;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.scalar.arithmetic.BinaryScalar;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.DoubleType;
import java.util.function.DoubleUnaryOperator;

public final class TrigonometricFunctions {
    public static void register(ScalarFunctionModule module) {
        TrigonometricFunctions.register(module, "sin", Math::sin);
        TrigonometricFunctions.register(module, "asin", x -> Math.asin(TrigonometricFunctions.checkRange(x)));
        TrigonometricFunctions.register(module, "cos", Math::cos);
        TrigonometricFunctions.register(module, "acos", x -> Math.acos(TrigonometricFunctions.checkRange(x)));
        TrigonometricFunctions.register(module, "tan", Math::tan);
        TrigonometricFunctions.register(module, "cot", x -> 1.0 / Math.tan(x));
        TrigonometricFunctions.register(module, "atan", x -> Math.atan(TrigonometricFunctions.checkRange(x)));
        module.register(Signature.scalar("atan2", DataTypes.DOUBLE.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature()).withFeatures(Scalar.DETERMINISTIC_ONLY), (signature, boundSignature) -> new BinaryScalar<Double>(Math::atan2, (Signature)signature, (Signature)boundSignature, DoubleType.INSTANCE));
    }

    private static void register(ScalarFunctionModule module, String name, DoubleUnaryOperator func) {
        module.register(Signature.scalar(name, DataTypes.DOUBLE.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature()), (signature, boundSignature) -> new DoubleScalar((Signature)signature, (Signature)boundSignature, func));
    }

    private static double checkRange(double value) {
        if (value < -1.0 || value > 1.0) {
            throw new IllegalArgumentException("input value " + value + " is out of range. Values must be in range of [-1.0, 1.0]");
        }
        return value;
    }
}

