/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.expression.scalar.DoubleScalar;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;

public final class SquareRootFunction {
    public static final String NAME = "sqrt";

    public static void register(ScalarFunctionModule module) {
        for (DataType<?> type : DataTypes.NUMERIC_PRIMITIVE_TYPES) {
            TypeSignature typeSignature = type.getTypeSignature();
            module.register(Signature.scalar(NAME, typeSignature, DataTypes.DOUBLE.getTypeSignature()), (signature, boundSignature) -> new DoubleScalar((Signature)signature, (Signature)boundSignature, SquareRootFunction::sqrt));
        }
    }

    private static double sqrt(double value) {
        if (value < 0.0) {
            throw new IllegalArgumentException("cannot take square root of a negative number");
        }
        return Math.sqrt(value);
    }
}

