/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;

public final class RoundFunction {
    public static final String NAME = "round";

    public static void register(ScalarFunctionModule module) {
        for (DataType<?> type : DataTypes.NUMERIC_PRIMITIVE_TYPES) {
            TypeSignature typeSignature = type.getTypeSignature();
            DataType<?> returnType = DataTypes.getIntegralReturnType(type);
            assert (returnType != null) : "Could not get integral type of " + type;
            module.register(Signature.scalar(NAME, typeSignature, returnType.getTypeSignature()), (signature, boundSignature) -> {
                if (returnType.equals(DataTypes.INTEGER)) {
                    return new UnaryScalar<Integer, Object>((Signature)signature, (Signature)boundSignature, (DataType<Object>)type, x -> Math.round(((Number)x).floatValue()));
                }
                return new UnaryScalar<Long, Object>((Signature)signature, (Signature)boundSignature, (DataType<Object>)type, x -> Math.round(((Number)x).doubleValue()));
            });
        }
    }
}

