/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.util.Random;

public class RandomFunction
extends Scalar<Double, Void> {
    public static final String NAME = "random";
    private final Signature signature;
    private final Signature boundSignature;
    private final Random random = new Random();

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(NAME, DataTypes.DOUBLE.getTypeSignature()).withFeatures(NO_FEATURES), RandomFunction::new);
    }

    public RandomFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Symbol normalizeSymbol(Function symbol, TransactionContext txnCtx, NodeContext nodeCtx) {
        assert (symbol.arguments().size() == 0) : "function's number of arguments must be 0";
        return symbol;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Double evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
        assert (args.length == 0) : "number of args must be 0";
        return this.random.nextDouble();
    }
}

