/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.math.BigDecimal;

public final class NegateFunctions {
    public static final String NAME = "_negate";

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(NAME, TypeSignature.parseTypeSignature("double precision"), TypeSignature.parseTypeSignature("double precision")).withForbiddenCoercion(), (signature, boundSignature) -> new UnaryScalar<Double, Double>((Signature)signature, (Signature)boundSignature, DataTypes.DOUBLE, x -> x * -1.0));
        module.register(Signature.scalar(NAME, DataTypes.FLOAT.getTypeSignature(), DataTypes.FLOAT.getTypeSignature()).withForbiddenCoercion(), (signature, boundSignature) -> new UnaryScalar<Float, Float>((Signature)signature, (Signature)boundSignature, DataTypes.FLOAT, x -> Float.valueOf(x.floatValue() * -1.0f)));
        module.register(Signature.scalar(NAME, TypeSignature.parseTypeSignature("integer"), TypeSignature.parseTypeSignature("integer")).withForbiddenCoercion(), (signature, boundSignature) -> new UnaryScalar<Integer, Integer>((Signature)signature, (Signature)boundSignature, DataTypes.INTEGER, x -> x * -1));
        module.register(Signature.scalar(NAME, TypeSignature.parseTypeSignature("bigint"), TypeSignature.parseTypeSignature("bigint")).withForbiddenCoercion(), (signature, boundSignature) -> new UnaryScalar<Long, Long>((Signature)signature, (Signature)boundSignature, DataTypes.LONG, x -> x * -1L));
        module.register(Signature.scalar(NAME, TypeSignature.parseTypeSignature("smallint"), TypeSignature.parseTypeSignature("smallint")).withForbiddenCoercion(), (signature, boundSignature) -> new UnaryScalar<Short, Short>((Signature)signature, (Signature)boundSignature, DataTypes.SHORT, x -> (short)(x * -1)));
        module.register(Signature.scalar(NAME, DataTypes.NUMERIC.getTypeSignature(), DataTypes.NUMERIC.getTypeSignature()).withForbiddenCoercion(), (signature, boundSignature) -> new UnaryScalar<BigDecimal, BigDecimal>((Signature)signature, (Signature)boundSignature, DataTypes.NUMERIC, BigDecimal::negate));
    }
}

