/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.metadata.FunctionName;
import io.crate.metadata.FunctionType;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.TypeSignature;
import java.util.HashMap;
import java.util.List;

public class MapFunction
extends Scalar<Object, Object> {
    public static final String NAME = "_map";
    public static final Signature SIGNATURE = Signature.builder().name(new FunctionName(null, "_map")).kind(FunctionType.SCALAR).typeVariableConstraints(List.of(TypeVariableConstraint.typeVariableOfAnyType("V"))).argumentTypes(TypeSignature.parseTypeSignature("text"), TypeSignature.parseTypeSignature("V")).returnType(TypeSignature.parseTypeSignature("object(text, V)")).variableArityGroup(List.of(TypeSignature.parseTypeSignature("text"), TypeSignature.parseTypeSignature("V"))).build();
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(SIGNATURE, MapFunction::new);
    }

    private MapFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    @SafeVarargs
    public final Object evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        HashMap<String, Object> m = new HashMap<String, Object>(args.length / 2, 1.0f);
        for (int i = 0; i < args.length - 1; i += 2) {
            m.put((String)args[i].value(), args[i + 1].value());
        }
        return m;
    }
}

