/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;

public abstract class LogFunction
extends Scalar<Number, Number> {
    public static final String NAME = "log";
    protected final Signature signature;
    protected final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        LogBaseFunction.registerLogBaseFunctions(module);
        Log10Function.registerLog10Functions(module);
        LnFunction.registerLnFunctions(module);
    }

    LogFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    Double validateResult(Double result, String caller) {
        if (result == null) {
            return null;
        }
        if (Double.isNaN(result) || Double.isInfinite(result)) {
            throw new IllegalArgumentException(caller + ": given arguments would result in: '" + result + "'");
        }
        return result;
    }

    static class LogBaseFunction
    extends LogFunction {
        static void registerLogBaseFunctions(ScalarFunctionModule module) {
            module.register(Signature.scalar(LogFunction.NAME, DataTypes.DOUBLE.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature(), TypeSignature.parseTypeSignature("double precision")), LogBaseFunction::new);
        }

        LogBaseFunction(Signature signature, Signature boundSignature) {
            super(signature, boundSignature);
        }

        @Override
        public Number evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Number> ... args) {
            assert (args.length == 2) : "number of args must be 2";
            Number value1 = args[0].value();
            Number value2 = args[1].value();
            if (value1 == null || value2 == null) {
                return null;
            }
            double value = value1.doubleValue();
            double base = value2.doubleValue();
            double baseResult = Math.log(base);
            if (baseResult == 0.0) {
                throw new IllegalArgumentException("log(x, b): given 'base' would result in a division by zero.");
            }
            return this.validateResult(Math.log(value) / baseResult, "log(x, b)");
        }
    }

    static class Log10Function
    extends LogFunction {
        static void registerLog10Functions(ScalarFunctionModule module) {
            module.register(Signature.scalar(LogFunction.NAME, DataTypes.DOUBLE.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature()), Log10Function::new);
        }

        Log10Function(Signature signature, Signature boundSignature) {
            super(signature, boundSignature);
        }

        @Override
        public Number evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Number> ... args) {
            assert (args.length == 1) : "number of args must be 1";
            Number value = args[0].value();
            if (value == null) {
                return null;
            }
            return this.evaluate(value.doubleValue());
        }

        protected Double evaluate(double value) {
            return this.validateResult(Math.log10(value), "log(x)");
        }
    }

    public static class LnFunction
    extends Log10Function {
        public static final String NAME = "ln";

        static void registerLnFunctions(ScalarFunctionModule module) {
            module.register(Signature.scalar(NAME, DataTypes.DOUBLE.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature()), LnFunction::new);
        }

        LnFunction(Signature signature, Signature boundSignature) {
            super(signature, boundSignature);
        }

        @Override
        protected Double evaluate(double value) {
            return this.validateResult(Math.log(value), "ln(x)");
        }
    }
}

