/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TimestampType;
import java.util.List;
import java.util.function.BiFunction;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Period;

public class IntervalTimestampArithmeticScalar
extends Scalar<Long, Object>
implements BiFunction<Long, Period, Long> {
    private final BiFunction<DateTime, Period, DateTime> operation;
    private final Signature signature;
    private final Signature boundSignature;
    private final int periodIdx;
    private final int timestampIdx;

    public static void register(ScalarFunctionModule module) {
        for (TimestampType timestampType : List.of(DataTypes.TIMESTAMP, DataTypes.TIMESTAMPZ)) {
            module.register(Signature.scalar("add", DataTypes.INTERVAL.getTypeSignature(), timestampType.getTypeSignature(), timestampType.getTypeSignature()).withForbiddenCoercion(), (signature, boundSignature) -> new IntervalTimestampArithmeticScalar("+", (Signature)signature, (Signature)boundSignature));
            module.register(IntervalTimestampArithmeticScalar.signatureFor(timestampType, "add"), (signature, boundSignature) -> new IntervalTimestampArithmeticScalar("+", (Signature)signature, (Signature)boundSignature));
            module.register(IntervalTimestampArithmeticScalar.signatureFor(timestampType, "subtract"), (signature, boundSignature) -> new IntervalTimestampArithmeticScalar("-", (Signature)signature, (Signature)boundSignature));
        }
    }

    public static Signature signatureFor(DataType<?> timestampType, String name) {
        return Signature.scalar(name, timestampType.getTypeSignature(), DataTypes.INTERVAL.getTypeSignature(), timestampType.getTypeSignature()).withForbiddenCoercion();
    }

    public IntervalTimestampArithmeticScalar(String operator, Signature declaredSignature, Signature boundSignature) {
        this.signature = declaredSignature;
        this.boundSignature = boundSignature;
        DataType<?> firstArgType = boundSignature.getArgumentDataTypes().get(0);
        if (firstArgType.id() == 17) {
            this.periodIdx = 0;
            this.timestampIdx = 1;
        } else {
            this.periodIdx = 1;
            this.timestampIdx = 0;
        }
        switch (operator) {
            case "+": {
                this.operation = DateTime::plus;
                break;
            }
            case "-": {
                if (firstArgType.id() == 17) {
                    throw new IllegalArgumentException("Unsupported operator for interval " + operator);
                }
                this.operation = DateTime::minus;
                break;
            }
            default: {
                this.operation = (a, b) -> {
                    throw new IllegalArgumentException("Unsupported operator for interval " + operator);
                };
            }
        }
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Long evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object>[] args) {
        Long timestamp = (Long)args[this.timestampIdx].value();
        Period period = (Period)args[this.periodIdx].value();
        return this.apply(timestamp, period);
    }

    @Override
    public Long apply(Long timestamp, Period period) {
        if (period == null || timestamp == null) {
            return null;
        }
        return this.operation.apply(new DateTime((Object)timestamp, DateTimeZone.UTC), period).toInstant().getMillis();
    }
}

