/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import java.util.function.BiFunction;
import org.joda.time.Period;

public class IntervalArithmeticScalar
extends Scalar<Period, Object> {
    private final Signature signature;
    private final Signature boundSignature;
    private final BiFunction<Period, Period, Period> operation;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar("add", DataTypes.INTERVAL.getTypeSignature(), DataTypes.INTERVAL.getTypeSignature(), DataTypes.INTERVAL.getTypeSignature()), (signature, boundSignature) -> new IntervalArithmeticScalar("+", (Signature)signature, (Signature)boundSignature));
        module.register(Signature.scalar("subtract", DataTypes.INTERVAL.getTypeSignature(), DataTypes.INTERVAL.getTypeSignature(), DataTypes.INTERVAL.getTypeSignature()), (signature, boundSignature) -> new IntervalArithmeticScalar("-", (Signature)signature, (Signature)boundSignature));
    }

    IntervalArithmeticScalar(String operator, Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        switch (operator) {
            case "+": {
                this.operation = Period::plus;
                break;
            }
            case "-": {
                this.operation = Period::minus;
                break;
            }
            default: {
                this.operation = (a, b) -> {
                    throw new IllegalArgumentException("Unsupported operator for interval " + operator);
                };
            }
        }
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Period evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object>[] args) {
        Period fst = (Period)args[0].value();
        Period snd = (Period)args[1].value();
        if (fst == null || snd == null) {
            return null;
        }
        return this.operation.apply(fst, snd);
    }
}

