/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;
import java.util.List;

public final class CeilFunction {
    public static final String CEIL = "ceil";
    public static final String CEILING = "ceiling";

    public static void register(ScalarFunctionModule module) {
        for (DataType<?> type : DataTypes.NUMERIC_PRIMITIVE_TYPES) {
            TypeSignature typeSignature = type.getTypeSignature();
            DataType<?> returnType = DataTypes.getIntegralReturnType(type);
            assert (returnType != null) : "Could not get integral type of " + type;
            for (String name : List.of(CEIL, CEILING)) {
                module.register(Signature.scalar(name, typeSignature, returnType.getTypeSignature()), (signature, boundSignature) -> new UnaryScalar<Object, Object>((Signature)signature, (Signature)boundSignature, (DataType<Object>)type, x -> returnType.sanitizeValue(Math.ceil(((Number)x).doubleValue()))));
            }
        }
    }
}

