/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.metadata.FunctionType;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.metadata.functions.TypeVariableConstraint;
import io.crate.types.TypeSignature;
import java.util.ArrayList;

public class ArrayFunction
extends Scalar<Object, Object> {
    public static final String NAME = "_array";
    public static final Signature SIGNATURE = Signature.builder().name("_array").kind(FunctionType.SCALAR).typeVariableConstraints(TypeVariableConstraint.typeVariable("E")).argumentTypes(TypeSignature.parseTypeSignature("E")).returnType(TypeSignature.parseTypeSignature("array(E)")).setVariableArity(true).build();
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(SIGNATURE, ArrayFunction::new);
    }

    private ArrayFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    @SafeVarargs
    public final Object evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        ArrayList<Object> values = new ArrayList<Object>(args.length);
        for (Input<Object> arg : args) {
            values.add(arg.value());
        }
        return values;
    }
}

