/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.scalar.arithmetic.BinaryScalar;
import io.crate.metadata.Scalar;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import java.math.BigDecimal;
import java.math.MathContext;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.BinaryOperator;

public class ArithmeticFunctions {
    public static void register(ScalarFunctionModule module) {
        for (Operations op : Operations.values()) {
            module.register(Signature.scalar(op.toString(), DataTypes.INTEGER.getTypeSignature(), DataTypes.INTEGER.getTypeSignature(), DataTypes.INTEGER.getTypeSignature()).withFeatures(op.features), (signature, boundSignature) -> new BinaryScalar<Integer>(op.integerFunction, (Signature)signature, (Signature)boundSignature, DataTypes.INTEGER));
            for (DataType dataType : List.of(DataTypes.LONG, DataTypes.TIMESTAMP, DataTypes.TIMESTAMPZ)) {
                module.register(Signature.scalar(op.toString(), dataType.getTypeSignature(), dataType.getTypeSignature(), dataType.getTypeSignature()).withFeatures(op.features), (signature, boundSignature) -> new BinaryScalar<Long>(op.longFunction, (Signature)signature, (Signature)boundSignature, type));
            }
            module.register(Signature.scalar(op.toString(), DataTypes.FLOAT.getTypeSignature(), DataTypes.FLOAT.getTypeSignature(), DataTypes.FLOAT.getTypeSignature()).withFeatures(op.features), (signature, boundSignature) -> new BinaryScalar<Float>(op.floatFunction, (Signature)signature, (Signature)boundSignature, DataTypes.FLOAT));
            module.register(Signature.scalar(op.toString(), DataTypes.DOUBLE.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature()).withFeatures(op.features), (signature, boundSignature) -> new BinaryScalar<Double>(op.doubleFunction, (Signature)signature, (Signature)boundSignature, DataTypes.DOUBLE));
            module.register(Signature.scalar(op.toString(), DataTypes.NUMERIC.getTypeSignature(), DataTypes.NUMERIC.getTypeSignature(), DataTypes.NUMERIC.getTypeSignature()).withFeatures(op.features), (signature, boundSignature) -> new BinaryScalar<BigDecimal>(op.bdFunction, (Signature)signature, (Signature)boundSignature, DataTypes.NUMERIC));
        }
        module.register(Signature.scalar("power", DataTypes.DOUBLE.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature(), DataTypes.DOUBLE.getTypeSignature()).withFeatures(Scalar.DETERMINISTIC_ONLY), (signature, boundSignature) -> new BinaryScalar<Double>(Math::pow, (Signature)signature, (Signature)boundSignature, DataTypes.DOUBLE));
    }

    private static enum Operations {
        ADD(Scalar.DETERMINISTIC_AND_COMPARISON_REPLACEMENT, Math::addExact, Double::sum, Math::addExact, Float::sum, BigDecimal::add),
        SUBTRACT(Scalar.DETERMINISTIC_ONLY, Math::subtractExact, (arg0, arg1) -> arg0 - arg1, Math::subtractExact, (arg0, arg1) -> Float.valueOf(arg0.floatValue() - arg1.floatValue()), BigDecimal::subtract),
        MULTIPLY(Scalar.DETERMINISTIC_ONLY, Math::multiplyExact, (arg0, arg1) -> arg0 * arg1, Math::multiplyExact, (arg0, arg1) -> Float.valueOf(arg0.floatValue() * arg1.floatValue()), BigDecimal::multiply),
        DIVIDE(Scalar.DETERMINISTIC_ONLY, (arg0, arg1) -> arg0 / arg1, (arg0, arg1) -> arg0 / arg1, (arg0, arg1) -> arg0 / arg1, (arg0, arg1) -> Float.valueOf(arg0.floatValue() / arg1.floatValue()), (arg0, arg1) -> arg0.divide((BigDecimal)arg1, MathContext.DECIMAL64)),
        MODULUS(Scalar.DETERMINISTIC_ONLY, (arg0, arg1) -> arg0 % arg1, (arg0, arg1) -> arg0 % arg1, (arg0, arg1) -> arg0 % arg1, (arg0, arg1) -> Float.valueOf(arg0.floatValue() % arg1.floatValue()), BigDecimal::remainder),
        MOD(Scalar.DETERMINISTIC_ONLY, (arg0, arg1) -> arg0 % arg1, (arg0, arg1) -> arg0 % arg1, (arg0, arg1) -> arg0 % arg1, (arg0, arg1) -> Float.valueOf(arg0.floatValue() % arg1.floatValue()), BigDecimal::remainder);

        private final Set<Scalar.Feature> features;
        private final BinaryOperator<Integer> integerFunction;
        private final BinaryOperator<Double> doubleFunction;
        private final BinaryOperator<Long> longFunction;
        private final BinaryOperator<Float> floatFunction;
        private final BinaryOperator<BigDecimal> bdFunction;

        private Operations(Set<Scalar.Feature> features, BinaryOperator<Integer> integerFunction, BinaryOperator<Double> doubleFunction, BinaryOperator<Long> longFunction, BinaryOperator<Float> floatFunction, BinaryOperator<BigDecimal> bdFunction) {
            this.features = features;
            this.doubleFunction = doubleFunction;
            this.integerFunction = integerFunction;
            this.longFunction = longFunction;
            this.floatFunction = floatFunction;
            this.bdFunction = bdFunction;
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    public static class Names {
        public static final String ADD = "add";
        public static final String SUBTRACT = "subtract";
        public static final String MULTIPLY = "multiply";
        public static final String DIVIDE = "divide";
        public static final String POWER = "power";
        public static final String MODULUS = "modulus";
        public static final String MOD = "mod";
    }
}

