/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar.arithmetic;

import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.scalar.UnaryScalar;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.TypeSignature;

public final class AbsFunction {
    public static final String NAME = "abs";

    public static void register(ScalarFunctionModule module) {
        for (DataType<?> type : DataTypes.NUMERIC_PRIMITIVE_TYPES) {
            TypeSignature typeSignature = type.getTypeSignature();
            module.register(Signature.scalar(NAME, typeSignature, typeSignature), (signature, boundSignature) -> {
                DataType<?> argType = boundSignature.getArgumentDataTypes().get(0);
                return new UnaryScalar<Object, Object>((Signature)signature, (Signature)boundSignature, (DataType<Object>)argType, x -> argType.sanitizeValue(Math.abs(((Number)x).doubleValue())));
            });
        }
    }
}

