/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.ThreeParametersFunction;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;

public final class TripleScalar<R, T>
extends Scalar<R, T> {
    private final Signature signature;
    private final Signature boundSignature;
    private final ThreeParametersFunction<T, T, T, R> func;
    private final DataType<T> type;

    public TripleScalar(Signature signature, Signature boundSignature, DataType<T> type, ThreeParametersFunction<T, T, T, R> func) {
        assert (boundSignature.getArgumentDataTypes().stream().allMatch(t -> t.id() == type.id())) : "All argument types of the bound signature must match the type argument";
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.type = type;
        this.func = func;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    @SafeVarargs
    public final R evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<T> ... args) {
        assert (args.length == 3) : "TripleScalar expects exactly 3 arguments, got: " + args.length;
        T value1 = this.type.sanitizeValue(args[0].value());
        if (value1 == null) {
            return null;
        }
        T value2 = this.type.sanitizeValue(args[1].value());
        if (value2 == null) {
            return null;
        }
        T value3 = this.type.sanitizeValue(args[2].value());
        if (value3 == null) {
            return null;
        }
        return this.func.apply(value1, value2, value3);
    }
}

