/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.common.annotations.VisibleForTesting;
import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import javax.annotation.Nonnull;

public class SubstrFunction
extends Scalar<String, Object> {
    public static final String NAME = "substr";
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(Signature.scalar(NAME, DataTypes.STRING.getTypeSignature(), DataTypes.INTEGER.getTypeSignature(), DataTypes.STRING.getTypeSignature()), SubstrFunction::new);
        module.register(Signature.scalar(NAME, DataTypes.STRING.getTypeSignature(), DataTypes.INTEGER.getTypeSignature(), DataTypes.INTEGER.getTypeSignature(), DataTypes.STRING.getTypeSignature()), SubstrFunction::new);
    }

    private SubstrFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public String evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input[] args) {
        assert (args.length == 2 || args.length == 3) : "number of arguments must be 2 or 3";
        String val = (String)args[0].value();
        if (val == null) {
            return null;
        }
        Number beginIdx = (Number)args[1].value();
        if (beginIdx == null) {
            return null;
        }
        if (args.length == 3) {
            Number len = (Number)args[2].value();
            if (len == null) {
                return null;
            }
            return SubstrFunction.evaluate(val, beginIdx.intValue(), len.intValue());
        }
        return SubstrFunction.evaluate(val, beginIdx.intValue());
    }

    private static String evaluate(@Nonnull String inputStr, int beginIdx) {
        int startPos = Math.max(0, beginIdx - 1);
        if (startPos > inputStr.length() - 1) {
            return "";
        }
        int endPos = inputStr.length();
        return SubstrFunction.substring(inputStr, startPos, endPos);
    }

    @VisibleForTesting
    static String evaluate(@Nonnull String inputStr, int beginIdx, int len) {
        int startPos = Math.max(0, beginIdx - 1);
        if (startPos > inputStr.length() - 1) {
            return "";
        }
        int endPos = inputStr.length();
        if (startPos + len < endPos) {
            endPos = startPos + len;
        }
        return SubstrFunction.substring(inputStr, startPos, endPos);
    }

    @VisibleForTesting
    static String substring(String value, int begin, int end) {
        return value.substring(begin, end);
    }
}

