/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.data.Row;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataTypes;
import io.crate.types.RowType;

public final class SubscriptRecordFunction
extends Scalar<Object, Object> {
    public static final String NAME = "_subscript_record";
    public static final Signature SIGNATURE = Signature.scalar("_subscript_record", RowType.EMPTY.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.UNDEFINED.getTypeSignature());
    private final Signature signature;
    private final Signature boundSignature;
    private final RowType rowType;

    public static void register(ScalarFunctionModule module) {
        module.register(SIGNATURE, SubscriptRecordFunction::new);
    }

    public SubscriptRecordFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
        this.rowType = (RowType)boundSignature.getArgumentDataTypes().get(0);
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    @SafeVarargs
    public final Object evaluate(TransactionContext txnCtx, NodeContext nodeCtx, Input<Object> ... args) {
        Row record = (Row)args[0].value();
        if (record == null) {
            return null;
        }
        String fieldName = (String)args[1].value();
        int idx = this.rowType.fieldNames().indexOf(fieldName);
        if (idx < 0) {
            throw new IllegalStateException("Couldn't find fieldname `" + fieldName + "` within RowType `" + this.rowType + "`");
        }
        return record.get(idx);
    }
}

