/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.data.Input;
import io.crate.expression.scalar.ScalarFunctionModule;
import io.crate.expression.scalar.SubscriptFunction;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.NodeContext;
import io.crate.metadata.Scalar;
import io.crate.metadata.TransactionContext;
import io.crate.metadata.functions.Signature;
import io.crate.types.DataType;
import io.crate.types.DataTypes;
import io.crate.types.ObjectType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;

public class SubscriptObjectFunction
extends Scalar<Object, Map<String, Object>> {
    public static final String NAME = "subscript_obj";
    public static final Signature SIGNATURE = Signature.scalar("subscript_obj", DataTypes.UNTYPED_OBJECT.getTypeSignature(), DataTypes.STRING.getTypeSignature(), DataTypes.UNDEFINED.getTypeSignature()).withVariableArity();
    private final Signature signature;
    private final Signature boundSignature;

    public static void register(ScalarFunctionModule module) {
        module.register(SIGNATURE, SubscriptObjectFunction::new);
    }

    private SubscriptObjectFunction(Signature signature, Signature boundSignature) {
        this.signature = signature;
        this.boundSignature = boundSignature;
    }

    @Override
    public Signature signature() {
        return this.signature;
    }

    @Override
    public Signature boundSignature() {
        return this.boundSignature;
    }

    @Override
    public Symbol normalizeSymbol(Function func, TransactionContext txnCtx, NodeContext nodeCtx) {
        Symbol result = SubscriptObjectFunction.evaluateIfLiterals(this, txnCtx, nodeCtx, func);
        if (result instanceof Literal) {
            return result;
        }
        return SubscriptObjectFunction.tryToInferReturnTypeFromObjectTypeAndArguments(func);
    }

    static Symbol tryToInferReturnTypeFromObjectTypeAndArguments(Function func) {
        if (!func.valueType().equals(DataTypes.UNDEFINED)) {
            return func;
        }
        List<Symbol> arguments = func.arguments();
        ObjectType objectType = (ObjectType)arguments.get(0).valueType();
        List<String> path = SubscriptObjectFunction.maybeCreatePath(arguments);
        if (path == null) {
            return func;
        }
        DataType<?> returnType = objectType.resolveInnerType(path);
        return returnType.equals(DataTypes.UNDEFINED) ? func : new Function(func.signature(), func.arguments(), returnType);
    }

    @Nullable
    private static List<String> maybeCreatePath(List<Symbol> arguments) {
        ArrayList<String> path = null;
        for (int i = 1; i < arguments.size(); ++i) {
            Symbol arg = arguments.get(i);
            if (arg instanceof Literal) {
                if (path == null) {
                    path = new ArrayList<String>();
                }
            } else {
                return null;
            }
            path.add(DataTypes.STRING.sanitizeValue(((Literal)arg).value()));
        }
        return path;
    }

    @Override
    @SafeVarargs
    public final Object evaluate(TransactionContext txnCtx, NodeContext ndeCtx, Input<Map<String, Object>> ... args) {
        assert (args.length >= 2) : "subscript_obj takes 2 or more arguments, got " + args.length;
        Object mapValue = args[0].value();
        for (int i = 1; i < args.length; ++i) {
            if (mapValue == null) {
                return null;
            }
            mapValue = SubscriptFunction.lookupByName(mapValue, args[i].value());
        }
        return mapValue;
    }
}

