/*
 * Decompiled with CFR 0.152.
 */
package io.crate.expression.scalar;

import io.crate.common.collections.Lists2;
import io.crate.expression.scalar.SubscriptObjectFunction;
import io.crate.expression.scalar.SubscriptRecordFunction;
import io.crate.expression.symbol.Function;
import io.crate.expression.symbol.Literal;
import io.crate.expression.symbol.Symbol;
import io.crate.metadata.ColumnIdent;
import io.crate.types.DataType;
import io.crate.types.ObjectType;
import io.crate.types.RowType;
import java.util.List;
import javax.annotation.Nullable;

public final class SubscriptFunctions {
    public static Function makeObjectSubscript(Symbol base, List<String> path) {
        assert (base.valueType().id() == 12) : "makeObjectSubscript only works on base symbols of type `object`, got `" + base.valueType().getName() + "`";
        List<Symbol> arguments = Lists2.mapTail(base, path, Literal::of);
        DataType<?> returnType = ((ObjectType)base.valueType()).resolveInnerType(path);
        return new Function(SubscriptObjectFunction.SIGNATURE, arguments, returnType);
    }

    public static Function makeObjectSubscript(Symbol base, ColumnIdent column) {
        return SubscriptFunctions.makeObjectSubscript(base, column.path());
    }

    @Nullable
    public static Function tryCreateSubscript(Symbol baseSymbol, List<String> path) {
        assert (!path.isEmpty()) : "Path must not be empty to create subscript function";
        DataType<?> baseType = baseSymbol.valueType();
        switch (baseType.id()) {
            case 12: {
                List<Symbol> arguments = Lists2.mapTail(baseSymbol, path, Literal::of);
                DataType<?> returnType = ((ObjectType)baseType).resolveInnerType(path);
                return new Function(SubscriptObjectFunction.SIGNATURE, arguments, returnType);
            }
            case 18: {
                String child = path.get(0);
                RowType rowType = (RowType)baseType;
                int idx = rowType.fieldNames().indexOf(child);
                if (idx < 0) {
                    return null;
                }
                Function recordSubscript = new Function(SubscriptRecordFunction.SIGNATURE, List.of(baseSymbol, Literal.of(child)), rowType.getFieldType(idx));
                if (path.size() > 1) {
                    return SubscriptFunctions.tryCreateSubscript(recordSubscript, path.subList(1, path.size()));
                }
                return recordSubscript;
            }
        }
        return null;
    }
}

